/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;

public class PropertyNames
extends Keyword {
    public static final String NAME = "propertyNames";

    public PropertyNames() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        context.checkValidSchema(value);
        if (!instance.isJsonObject()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : instance.getAsJsonObject().keySet()) {
            if (context.apply(value, null, null, (JsonElement)new JsonPrimitive(name), name)) continue;
            if (context.isFailFast()) {
                return false;
            }
            if (sb.length() > 0) {
                sb.append(", \"");
            } else {
                sb.append("invalid property names: \"");
            }
            sb.append(Strings.jsonString(name)).append('\"');
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

