/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;

public class Required
extends Keyword {
    public static final String NAME = "required";

    public Required() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!value.isJsonArray()) {
            context.schemaError("not an array");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        JsonObject object = instance.getAsJsonObject();
        int index = 0;
        for (JsonElement e : value.getAsJsonArray()) {
            if (!JSON.isString(e)) {
                context.schemaError("not a string", Integer.toString(index));
                return false;
            }
            if (!object.has(e.getAsString())) {
                if (context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", \"");
                } else {
                    sb.append("required properties not found: \"");
                }
                sb.append(Strings.jsonString(e.getAsString())).append('\"');
            }
            ++index;
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

