/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;
import java.util.Map;
import java.util.function.Function;

public class UnevaluatedItems
extends Keyword {
    public static final String NAME = "unevaluatedItems";

    public UnevaluatedItems() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) < 0) {
            return true;
        }
        if (!context.isCollectAnnotations()) {
            context.schemaError("annotations are not being collected");
            return false;
        }
        context.checkValidSchema(value);
        if (!instance.isJsonArray()) {
            return true;
        }
        JSONPath parentPath = context.schemaParentLocation();
        int max = 0;
        Function<Map, Boolean> f = a -> {
            for (Map.Entry e : a.entrySet()) {
                if (!((Annotation)e.getValue()).isValid() || ((JSONPath)e.getKey()).size() <= parentPath.size() || !((JSONPath)e.getKey()).startsWith(parentPath) || !Boolean.TRUE.equals(((Annotation)e.getValue()).value)) continue;
                return true;
            }
            return false;
        };
        if (f.apply(context.annotations("additionalItems")).booleanValue()) {
            return true;
        }
        if (f.apply(context.annotations(NAME)).booleanValue()) {
            return true;
        }
        Map<JSONPath, Annotation<?>> annotations = context.annotations("items");
        for (Map.Entry<JSONPath, Annotation<?>> e : annotations.entrySet()) {
            Object v;
            if (!e.getValue().isValid() || e.getKey().size() <= parentPath.size() || !e.getKey().startsWith(parentPath) || (v = e.getValue().value) == null) continue;
            if (v.equals(true)) {
                return true;
            }
            if (!(v instanceof Integer)) continue;
            max = Math.max(max, (Integer)v + 1);
        }
        StringBuilder sb = new StringBuilder();
        JsonArray array = instance.getAsJsonArray();
        for (int i = max; i < array.size(); ++i) {
            if (context.apply(value, null, null, array.get(i), Integer.toString(i))) continue;
            if (context.isFailFast()) {
                return false;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append("invalid unevaluated items: ");
            }
            sb.append(i);
        }
        context.addAnnotation(NAME, true);
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

