/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class UnevaluatedProperties
extends Keyword {
    public static final String NAME = "unevaluatedProperties";

    public UnevaluatedProperties() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) < 0) {
            return true;
        }
        if (!context.isCollectAnnotations()) {
            context.schemaError("annotations are not being collected");
            return false;
        }
        context.checkValidSchema(value);
        if (!instance.isJsonObject()) {
            return true;
        }
        JsonObject object = instance.getAsJsonObject();
        JSONPath parentPath = context.schemaParentLocation();
        HashSet validated = new HashSet();
        Consumer<Map> f = a -> {
            if (validated.size() >= object.size()) {
                return;
            }
            for (Map.Entry e : a.entrySet()) {
                if (!((Annotation)e.getValue()).isValid() || ((JSONPath)e.getKey()).size() <= parentPath.size() || !((JSONPath)e.getKey()).startsWith(parentPath) || !(((Annotation)e.getValue()).value instanceof Set)) continue;
                validated.addAll((Set)((Annotation)e.getValue()).value);
            }
        };
        f.accept(context.annotations("properties"));
        f.accept(context.annotations("patternProperties"));
        f.accept(context.annotations("additionalProperties"));
        f.accept(context.annotations(NAME));
        StringBuilder sb = new StringBuilder();
        HashSet<String> thisValidated = new HashSet<String>();
        if (validated.size() < object.size()) {
            for (Map.Entry e : object.entrySet()) {
                if (validated.contains(e.getKey())) continue;
                if (!context.apply(value, null, null, (JsonElement)e.getValue(), (String)e.getKey())) {
                    if (context.isFailFast()) {
                        return false;
                    }
                    if (sb.length() > 0) {
                        sb.append(", \"");
                    } else {
                        sb.append("invalid unevaluated properties: \"");
                    }
                    sb.append(Strings.jsonString((String)e.getKey())).append('\"');
                }
                thisValidated.add((String)e.getKey());
            }
        }
        context.addAnnotation(NAME, thisValidated);
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

