/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;

public class UniqueItems
extends Keyword {
    public static final String NAME = "uniqueItems";

    public UniqueItems() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!JSON.isBoolean(value)) {
            context.schemaError("not a Boolean");
            return false;
        }
        if (!value.getAsBoolean()) {
            return true;
        }
        if (!instance.isJsonArray()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<JsonElement> set = new HashSet<JsonElement>();
        int index = 0;
        for (JsonElement e : instance.getAsJsonArray()) {
            if (!set.add(e)) {
                if (context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                } else {
                    sb.append("non-unique items: ");
                }
                sb.append(index);
            }
            ++index;
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

