/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.net;

import com.qindesign.json.schema.net.URIParser;
import com.qindesign.json.schema.net.URISyntaxException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

public class URI
implements Comparable<URI> {
    private static final ThreadLocal<CharsetDecoder> decoder = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);
    private static final ThreadLocal<CharsetEncoder> encoder = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String scheme;
    private final String authority;
    private String decodedAuthority;
    private final String path;
    private String decodedPath;
    private final String query;
    private String decodedQuery;
    private final String fragment;
    private String decodedFragment;
    private final String userInfo;
    private String decodedUserInfo;
    private final String host;
    private String decodedHost;
    private final int port;
    private String string;
    private String decodedString;
    private String caseNormalizedString;

    public static void main(String[] args) throws URISyntaxException {
        URI uri = URI.parse("http://a/b/c/d;p?q");
        System.out.println(uri.resolve(URI.parse("g:h")));
    }

    public static URI parse(String s) throws URISyntaxException {
        return new URIParser(s).parse();
    }

    public static URI parseUnchecked(String s) {
        try {
            return URI.parse(s);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String encodeFragment(String fragment) {
        return URI.pctEncode(fragment, 0, fragment.length(), URIParser.QUERY_OR_FRAGMENT);
    }

    private static int fromHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Not a hex digit");
    }

    private static String pctDecode(String s) {
        if (s == null || s.isEmpty() || s.indexOf(37) < 0) {
            return s;
        }
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = decoder.get().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c != '%') {
                sb.append(c);
                ++i;
                continue;
            }
            bb.clear();
            do {
                if (i + 2 >= n) {
                    throw new IllegalArgumentException("Bad percent-encoding");
                }
                int n2 = ++i;
                int n3 = ++i;
                bb.put((byte)(URI.fromHex(s.charAt(n2)) << 4 | URI.fromHex(s.charAt(n3))));
            } while (++i < n && s.charAt(i) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                throw new IllegalArgumentException("Bad UTF-8");
            }
            cr = dec.flush(cb);
            if (!cr.isUnderflow()) {
                throw new IllegalArgumentException("Bad UTF-8");
            }
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }

    private static String pctEncode(String s, int start, int end, BitSet notThese) {
        int charCount;
        StringBuilder sb = null;
        char[] ca = new char[2];
        for (int i = start; i < end; i += charCount) {
            int c = s.codePointAt(i);
            charCount = Character.charCount(c);
            if (c < 128) {
                if (c != 37 && notThese.get(c)) {
                    if (sb == null) continue;
                    sb.append((char)c);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(s, 0, i);
                }
                sb.append('%').append(HEX_DIGITS[c >> 4]).append(HEX_DIGITS[c & 0xF]);
                continue;
            }
            ca[0] = s.charAt(i);
            if (charCount == 2) {
                ca[1] = s.charAt(i + 1);
            }
            try {
                ByteBuffer bb = encoder.get().encode(CharBuffer.wrap(ca, 0, charCount));
                while (bb.hasRemaining()) {
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append(s, 0, i);
                    }
                    int b = bb.get() & 0xFF;
                    sb.append('%').append(HEX_DIGITS[b >> 4]).append(HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            catch (CharacterCodingException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (sb == null) {
            return s.substring(start, end);
        }
        return sb.toString();
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        URIParser p = new URIParser(URI.toEncodedString(scheme, authority, path, query, fragment));
        p.parse();
        this.scheme = p.scheme;
        this.authority = p.authority;
        this.path = p.path;
        this.query = p.query;
        this.fragment = p.fragment;
        this.userInfo = p.userInfo;
        this.host = p.host;
        this.port = p.port;
    }

    public URI(java.net.URI uri) {
        this.scheme = uri.getScheme();
        this.authority = uri.getRawAuthority();
        this.path = Optional.ofNullable(uri.getRawPath()).orElse("");
        this.query = uri.getRawQuery();
        this.fragment = uri.getRawFragment();
        if (this.authority == null) {
            this.userInfo = null;
            this.host = null;
            this.port = -1;
        } else {
            this.userInfo = uri.getRawUserInfo();
            this.host = Optional.ofNullable(uri.getHost()).orElse("");
            this.port = uri.getPort();
        }
    }

    URI(String scheme, String authority, String userInfo, String host, int port, String path, String query, String fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public String scheme() {
        return this.scheme;
    }

    public String authority() {
        if (this.decodedAuthority == null) {
            this.decodedAuthority = URI.pctDecode(this.authority);
        }
        return this.decodedAuthority;
    }

    public String rawAuthority() {
        return this.authority;
    }

    public String path() {
        if (this.decodedPath == null) {
            this.decodedPath = URI.pctDecode(this.path);
        }
        return this.decodedPath;
    }

    public String rawPath() {
        return this.path;
    }

    public String query() {
        if (this.decodedQuery == null) {
            this.decodedQuery = URI.pctDecode(this.query);
        }
        return this.decodedQuery;
    }

    public String rawQuery() {
        return this.query;
    }

    public String fragment() {
        if (this.decodedFragment == null) {
            this.decodedFragment = URI.pctDecode(this.fragment);
        }
        return this.decodedFragment;
    }

    public String rawFragment() {
        return this.fragment;
    }

    public String userInfo() {
        if (this.decodedUserInfo == null) {
            this.decodedUserInfo = URI.pctDecode(this.userInfo);
        }
        return this.decodedUserInfo;
    }

    public String rawUserInfo() {
        return this.userInfo;
    }

    public String host() {
        if (this.decodedHost == null) {
            this.decodedHost = URI.pctDecode(this.host);
        }
        return this.decodedHost;
    }

    public String rawHost() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    @Deprecated
    public boolean isOpaque() {
        return this.scheme != null && !this.path.isEmpty() && !this.path.startsWith("/");
    }

    public boolean isNetworkPathReference() {
        return this.scheme == null && this.authority != null;
    }

    public boolean isAbsolutePathReference() {
        return this.scheme == null && this.path.startsWith("/");
    }

    public boolean isRelativePathReference() {
        return this.scheme == null && !this.path.startsWith("/");
    }

    public URI resolve(URI r) {
        if (r.scheme != null) {
            return new URI(r.scheme, r.authority, r.userInfo, r.host, r.port, URI.removeDotSegments(r.path), r.query, r.fragment);
        }
        if (r.authority != null) {
            return new URI(this.scheme, r.authority, r.userInfo, r.host, r.port, URI.removeDotSegments(r.path), r.query, r.fragment);
        }
        if (r.path.isEmpty()) {
            if (r.query != null) {
                return new URI(this.scheme, this.authority, this.userInfo, this.host, this.port, this.path, r.query, r.fragment);
            }
            return new URI(this.scheme, this.authority, this.userInfo, this.host, this.port, this.path, this.query, r.fragment);
        }
        if (r.path.startsWith("/")) {
            return new URI(this.scheme, this.authority, this.userInfo, this.host, this.port, URI.removeDotSegments(r.path), r.query, r.fragment);
        }
        return new URI(this.scheme, this.authority, this.userInfo, this.host, this.port, URI.removeDotSegments(URI.merge(this, r.path)), r.query, r.fragment);
    }

    private static String merge(URI base, String path) {
        if (base.authority != null && base.path.isEmpty()) {
            return "/" + path;
        }
        int lastSlashIndex = base.path.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            return base.path.substring(0, lastSlashIndex + 1) + path;
        }
        return path;
    }

    private static String removeDotSegments(String path) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int end = path.length();
        while (end > start) {
            int lastSlashIndex;
            if (end - start >= 3 && path.startsWith("../", start)) {
                start += 3;
                continue;
            }
            if (end - start >= 2 && path.startsWith("./", start)) {
                start += 2;
                continue;
            }
            if (end - start >= 3 && path.startsWith("/./", start)) {
                start += 2;
                continue;
            }
            if (end - start == 2 && path.startsWith("/.", start)) {
                --end;
                continue;
            }
            if (end - start >= 4 && path.startsWith("/../", start)) {
                start += 3;
                lastSlashIndex = sb.lastIndexOf("/");
                sb.setLength(Math.max(lastSlashIndex, 0));
                continue;
            }
            if (end - start == 3 && path.startsWith("/..", start)) {
                end -= 2;
                lastSlashIndex = sb.lastIndexOf("/");
                sb.setLength(Math.max(lastSlashIndex, 0));
                continue;
            }
            if (end - start == 1 && path.charAt(start) == '.') {
                ++start;
                continue;
            }
            if (end - start == 2 && path.startsWith("..", start)) {
                start += 2;
                continue;
            }
            int nextSlashIndex = path.indexOf(47, start + 1);
            if (0 <= nextSlashIndex && nextSlashIndex < end) {
                sb.append(path, start, nextSlashIndex);
                start = nextSlashIndex;
                continue;
            }
            sb.append(path, start, end);
            start = end;
        }
        return sb.toString();
    }

    public URI relativize(URI r) {
        String rPath;
        if (!URI.equalsIgnoreCase(this.scheme, r.scheme) || !Objects.equals(this.authority, r.authority)) {
            return r;
        }
        Object thisPath = URI.removeDotSegments(this.path);
        if (!((String)thisPath).equals(rPath = URI.removeDotSegments(r.path))) {
            if (!((String)thisPath).endsWith("/")) {
                thisPath = (String)thisPath + "/";
            }
            if (!rPath.startsWith((String)thisPath)) {
                return r;
            }
        }
        return new URI(null, null, null, null, -1, rPath.substring(((String)thisPath).length()), r.query, r.fragment);
    }

    public URI normalize() {
        String scheme = Optional.ofNullable(this.scheme).map(String::toLowerCase).orElse(null);
        String host = Optional.ofNullable(this.host).map(String::toLowerCase).orElse(null);
        String path = URI.removeDotSegments(this.path);
        if (Objects.equals(scheme, this.scheme) && Objects.equals(host, this.host) && Objects.equals(path, this.path)) {
            return this;
        }
        return new URI(scheme, this.authority, this.userInfo, host, this.port, URI.removeDotSegments(path), this.query, this.fragment);
    }

    public URL toURL() throws MalformedURLException {
        if (this.scheme == null) {
            throw new IllegalArgumentException("URI has no scheme");
        }
        return new URL(this.toString());
    }

    @Override
    public int compareTo(URI o) {
        int c = URI.compareIgnoreCase(this.scheme(), o.scheme());
        if (c != 0) {
            return c;
        }
        if (this.isOpaque()) {
            if (o.isOpaque()) {
                c = URI.compare(this.path(), o.path());
                if (c != 0) {
                    return c;
                }
                c = URI.compare(this.query(), o.query());
                if (c != 0) {
                    return c;
                }
                return URI.compare(this.fragment(), o.fragment());
            }
            return 1;
        }
        if (o.isOpaque()) {
            return -1;
        }
        if (this.authority != null && o.authority != null) {
            c = URI.compare(this.userInfo(), o.userInfo());
            if (c != 0) {
                return c;
            }
            c = URI.compareIgnoreCase(this.host(), o.host());
            if (c != 0) {
                return c;
            }
            c = this.port - o.port;
            if (c != 0) {
                return c;
            }
        } else {
            c = URI.compare(this.authority(), o.authority());
            if (c != 0) {
                return c;
            }
        }
        if ((c = URI.compare(this.path(), o.path())) != 0) {
            return c;
        }
        c = URI.compare(this.query(), o.query());
        if (c != 0) {
            return c;
        }
        return URI.compare(this.fragment(), o.fragment());
    }

    private static int compare(String s1, String s2) {
        return Objects.compare(s1, s2, Comparator.nullsFirst(String::compareTo));
    }

    private static int compareIgnoreCase(String s1, String s2) {
        return Objects.compare(s1, s2, Comparator.nullsFirst(String::compareToIgnoreCase));
    }

    public int hashCode() {
        return this.toCaseNormalizedString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URI)) {
            return false;
        }
        URI o = (URI)obj;
        if (!URI.equalsIgnoreCase(this.scheme(), o.scheme())) {
            return false;
        }
        if (this.authority != null && o.authority != null) {
            if (!Objects.equals(this.userInfo(), o.userInfo())) {
                return false;
            }
            if (!URI.equalsIgnoreCase(this.host(), o.host())) {
                return false;
            }
            if (this.port != o.port) {
                return false;
            }
        } else if (!Objects.equals(this.authority(), o.authority())) {
            return false;
        }
        if (!Objects.equals(this.path(), o.path())) {
            return false;
        }
        if (!Objects.equals(this.query(), o.query())) {
            return false;
        }
        return Objects.equals(this.fragment(), o.fragment());
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equalsIgnoreCase(s2);
    }

    public String toString() {
        if (this.string == null) {
            this.string = URI.toRawString(this.scheme, this.authority, this.path, this.query, this.fragment);
        }
        return this.string;
    }

    public String toDecodedString() {
        if (this.decodedString == null) {
            this.decodedString = URI.toRawString(this.scheme(), this.authority(), this.path(), this.query(), this.fragment());
        }
        return this.decodedString;
    }

    private static String toRawString(String scheme, String authority, String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme).append(':');
        }
        if (authority != null) {
            sb.append("//").append(authority);
        }
        sb.append(path);
        if (query != null) {
            sb.append('?').append(query);
        }
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
        return sb.toString();
    }

    private static String toEncodedString(String scheme, String authority, String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme).append(':');
        }
        if (authority != null) {
            int index = 0;
            sb.append("//");
            int atIndex = authority.indexOf(64);
            if (atIndex >= 0) {
                sb.append(URI.pctEncode(authority, 0, atIndex, URIParser.USERINFO)).append('@');
                index = atIndex + 1;
            }
            if (authority.startsWith("[", index)) {
                sb.append(authority, index, authority.length());
            } else {
                int colonIndex = authority.indexOf(58, index);
                if (colonIndex >= 0) {
                    sb.append(URI.pctEncode(authority, index, colonIndex, URIParser.REG_NAME)).append(authority, colonIndex, authority.length());
                } else {
                    sb.append(URI.pctEncode(authority, index, authority.length(), URIParser.REG_NAME));
                }
            }
        }
        if (path != null) {
            sb.append(URI.pctEncode(path, 0, path.length(), URIParser.PATH));
        }
        if (query != null) {
            sb.append('?').append(URI.pctEncode(query, 0, query.length(), URIParser.QUERY_OR_FRAGMENT));
        }
        if (fragment != null) {
            sb.append('#').append(URI.pctEncode(fragment, 0, fragment.length(), URIParser.QUERY_OR_FRAGMENT));
        }
        return sb.toString();
    }

    public String toCaseNormalizedString() {
        if (this.caseNormalizedString == null) {
            StringBuilder sb = new StringBuilder();
            if (this.scheme != null) {
                sb.append(this.scheme().toLowerCase()).append(':');
            }
            if (this.authority != null) {
                sb.append("//");
                if (this.userInfo != null) {
                    sb.append(this.userInfo());
                }
                sb.append(this.host().toLowerCase());
                if (this.port >= 0) {
                    sb.append(this.port());
                }
            }
            sb.append(this.path());
            if (this.query != null) {
                sb.append('?').append(this.query());
            }
            if (this.fragment != null) {
                sb.append('#').append(this.fragment());
            }
            this.caseNormalizedString = sb.toString();
        }
        return this.caseNormalizedString;
    }
}

