/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.util;

import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Ecma262Pattern {
    private static final String WHITESPACE_CLASS;
    private static final String NON_WHITESPACE_CLASS;

    private Ecma262Pattern() {
    }

    public static String translate(String regex) {
        StringBuilder buf = new StringBuilder();
        int len = regex.length();
        for (int i = 0; i < len; ++i) {
            char c = regex.charAt(i);
            if (c == '\\') {
                if (i + 1 < len) {
                    c = regex.charAt(++i);
                    switch (c) {
                        case 'c': {
                            if (i + 1 < len) {
                                if ('a' <= (c = regex.charAt(++i)) && c <= 'z') {
                                    buf.append("\\c").append((char)(65 + (c - 97)));
                                    break;
                                }
                                buf.append("\\c").append(c);
                                break;
                            }
                            buf.append("\\c");
                            break;
                        }
                        case 's': {
                            buf.append(WHITESPACE_CLASS);
                            break;
                        }
                        case 'S': {
                            buf.append(NON_WHITESPACE_CLASS);
                            break;
                        }
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '/': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case '?': 
                        case 'B': 
                        case 'D': 
                        case 'P': 
                        case 'W': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case 'b': 
                        case 'd': 
                        case 'f': 
                        case 'k': 
                        case 'n': 
                        case 'p': 
                        case 'r': 
                        case 't': 
                        case 'u': 
                        case 'w': 
                        case 'x': 
                        case '{': 
                        case '|': 
                        case '}': {
                            buf.append('\\').append(c);
                            break;
                        }
                        case 'v': {
                            buf.append("\\u000B");
                            break;
                        }
                        case '0': {
                            if (i + 1 < len && "0123456789".indexOf(regex.charAt(i + 1)) >= 0) {
                                throw new PatternSyntaxException("NUL can't be followed by a decimal digit", regex, i + 1);
                            }
                            buf.append("\\u0000");
                            break;
                        }
                        default: {
                            if (Character.isUnicodeIdentifierPart(c)) {
                                throw new PatternSyntaxException("ID_Continue characters not allowed", regex, i);
                            }
                            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                                buf.append(c);
                                break;
                            }
                            buf.append('\\').append(c);
                            break;
                        }
                    }
                    continue;
                }
                buf.append('\\');
                continue;
            }
            if (c == '$') {
                buf.append("\\z");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static {
        Set WHITESPACE_CHARS = IntStream.range(0, 65536).filter(i -> Character.getType(i) == 12).boxed().map(i -> Character.valueOf((char)i.intValue())).collect(Collectors.toSet());
        WHITESPACE_CHARS.add(Character.valueOf('\t'));
        WHITESPACE_CHARS.add(Character.valueOf('\u000b'));
        WHITESPACE_CHARS.add(Character.valueOf('\f'));
        WHITESPACE_CHARS.add(Character.valueOf(' '));
        WHITESPACE_CHARS.add(Character.valueOf('\u00a0'));
        WHITESPACE_CHARS.add(Character.valueOf('\ufeff'));
        WHITESPACE_CHARS.add(Character.valueOf('\n'));
        WHITESPACE_CHARS.add(Character.valueOf('\r'));
        WHITESPACE_CHARS.add(Character.valueOf('\u2028'));
        WHITESPACE_CHARS.add(Character.valueOf('\u2029'));
        StringBuilder buf = new StringBuilder();
        WHITESPACE_CHARS.stream().sorted().forEach(c -> buf.append("\\u").append(String.format("%04X", c.charValue())));
        WHITESPACE_CLASS = "[" + buf + "]";
        NON_WHITESPACE_CLASS = "[^" + buf + "]";
    }
}

