/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import com.qiniu.android.dns.DnsException;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.util.BitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;

public final class DnsMessage {
    public static byte[] buildQuery(String domain, int id) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DataOutputStream dos = new DataOutputStream(baos);
        BitSet bits = new BitSet();
        bits.set(8);
        try {
            dos.writeShort((short)id);
            dos.writeShort((short)bits.value());
            dos.writeShort(1);
            dos.writeShort(0);
            dos.writeShort(0);
            dos.writeShort(0);
            dos.flush();
            DnsMessage.writeQuestion(baos, domain);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return baos.toByteArray();
    }

    private static void writeDomain(OutputStream out, String domain) throws IOException {
        for (String s : domain.split("[.\u3002\uff0e\uff61]")) {
            byte[] buffer = IDN.toASCII(s).getBytes();
            out.write(buffer.length);
            out.write(buffer, 0, buffer.length);
        }
        out.write(0);
    }

    private static void writeQuestion(OutputStream out, String domain) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        DnsMessage.writeDomain(out, domain);
        dos.writeShort(1);
        dos.writeShort(1);
    }

    public static Record[] parseResponse(byte[] response, int id, String domain) throws IOException {
        boolean recursionAvailable;
        ByteArrayInputStream bis = new ByteArrayInputStream(response);
        DataInputStream dis = new DataInputStream(bis);
        int answerId = dis.readUnsignedShort();
        if (answerId != id) {
            throw new DnsException(domain, "the answer id " + answerId + " is not match " + id);
        }
        int header = dis.readUnsignedShort();
        boolean recursionDesired = (header >> 8 & 1) == 1;
        boolean bl = recursionAvailable = (header >> 7 & 1) == 1;
        if (!recursionAvailable || !recursionDesired) {
            throw new DnsException(domain, "the dns server cant support recursion ");
        }
        int questionCount = dis.readUnsignedShort();
        int answerCount = dis.readUnsignedShort();
        dis.readUnsignedShort();
        dis.readUnsignedShort();
        DnsMessage.readQuestions(dis, response, questionCount);
        return DnsMessage.readAnswers(dis, response, answerCount);
    }

    private static String readName(DataInputStream dis, byte[] data) throws IOException {
        int c = dis.readUnsignedByte();
        if ((c & 0xC0) == 192) {
            c = ((c & 0x3F) << 8) + dis.readUnsignedByte();
            HashSet<Integer> jumps = new HashSet<Integer>();
            jumps.add(c);
            return DnsMessage.readName(data, c, jumps);
        }
        if (c == 0) {
            return "";
        }
        byte[] b = new byte[c];
        dis.readFully(b);
        String s = IDN.toUnicode(new String(b));
        String t = DnsMessage.readName(dis, data);
        if (t.length() > 0) {
            s = s + "." + t;
        }
        return s;
    }

    private static String readName(byte[] data, int offset, HashSet<Integer> jumps) throws IOException {
        int c = data[offset] & 0xFF;
        if ((c & 0xC0) == 192) {
            if (jumps.contains(c = ((c & 0x3F) << 8) + (data[offset + 1] & 0xFF))) {
                throw new DnsException("", "Cyclic offsets detected.");
            }
            jumps.add(c);
            return DnsMessage.readName(data, c, jumps);
        }
        if (c == 0) {
            return "";
        }
        String s = new String(data, offset + 1, c);
        String t = DnsMessage.readName(data, offset + 1 + c, jumps);
        if (t.length() > 0) {
            s = s + "." + t;
        }
        return s;
    }

    private static void readQuestions(DataInputStream dis, byte[] data, int count) throws IOException {
        while (count-- > 0) {
            DnsMessage.readName(dis, data);
            dis.readUnsignedShort();
            dis.readUnsignedShort();
        }
    }

    private static Record[] readAnswers(DataInputStream dis, byte[] data, int count) throws IOException {
        int offset = 0;
        Record[] ret = new Record[count];
        while (count-- > 0) {
            ret[offset++] = DnsMessage.readRecord(dis, data);
        }
        return ret;
    }

    private static Record readRecord(DataInputStream dis, byte[] data) throws IOException {
        DnsMessage.readName(dis, data);
        int type = dis.readUnsignedShort();
        dis.readUnsignedShort();
        long ttl = ((long)dis.readUnsignedShort() << 16) + (long)dis.readUnsignedShort();
        int payloadLength = dis.readUnsignedShort();
        String payload = null;
        switch (type) {
            case 1: {
                byte[] ip = new byte[4];
                dis.readFully(ip);
                payload = InetAddress.getByAddress(ip).getHostAddress();
                break;
            }
            case 5: {
                payload = DnsMessage.readName(dis, data);
                break;
            }
            default: {
                payload = null;
                for (int i = 0; i < payloadLength; ++i) {
                    dis.readByte();
                }
            }
        }
        if (payload == null) {
            throw new UnknownHostException("no record");
        }
        return new Record(payload, type, (int)ttl, System.currentTimeMillis() / 1000L, Record.Source.System);
    }
}

