/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.text.TextUtils;
import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.dns.NetworkInfo;
import java.util.Locale;

public final class NetworkReceiver
extends BroadcastReceiver {
    private static final Uri PREFERRED_APN_URI = Uri.parse((String)"content://telephony/carriers/preferapn");
    private static DnsManager mdnsManager;

    public static NetworkInfo createNetInfo(android.net.NetworkInfo info, Context context) {
        NetworkInfo.NetSatus net;
        if (info == null) {
            return NetworkInfo.noNetwork;
        }
        int provider = 0;
        int main = info.getType();
        if (main == 1) {
            net = NetworkInfo.NetSatus.WIFI;
            provider = 0;
        } else {
            String netMode;
            net = NetworkInfo.NetSatus.MOBILE;
            Cursor c = context.getContentResolver().query(PREFERRED_APN_URI, null, null, null, null);
            if (c != null) {
                c.moveToFirst();
                String user = c.getString(c.getColumnIndex("user"));
                if (!TextUtils.isEmpty((CharSequence)user) && (user.startsWith("ctwap") || user.startsWith("ctnet"))) {
                    provider = 1;
                }
            }
            c.close();
            if (provider != 1 && (netMode = info.getExtraInfo()) != null) {
                if ((netMode = netMode.toLowerCase(Locale.getDefault())).equals("cmwap") || netMode.equals("cmnet")) {
                    provider = 3;
                } else if (netMode.equals("3gnet") || netMode.equals("uninet") || netMode.equals("3gwap") || netMode.equals("uniwap")) {
                    provider = 2;
                }
            }
        }
        return new NetworkInfo(net, provider);
    }

    public static void setDnsManager(DnsManager dnsManager) {
        mdnsManager = dnsManager;
    }

    public void onReceive(Context context, Intent intent) {
        if (mdnsManager == null) {
            return;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        android.net.NetworkInfo activeInfo = manager.getActiveNetworkInfo();
        NetworkInfo info = NetworkReceiver.createNetInfo(activeInfo, context);
        mdnsManager.onNetworkChange(info);
    }
}

