/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.http;

import com.qiniu.android.dns.DnsException;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.util.DES;
import com.qiniu.android.dns.util.MD5;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QiniuDns
implements IResolver {
    private static final String ENDPOINT_SSL = "https://httpdns.qnydns.net:18443/";
    private static final String ENDPOINT = "http://httpdns.qnydns.net:18302/";
    private static String mAccountId;
    private static String mEncryptKey;
    private static int mExpireTimeSecond;
    private static boolean mIsEncrypted;
    private static boolean mIsHttps;

    public QiniuDns(String accountId, String encryptKey, int expireTimeSecond) {
        mAccountId = accountId;
        mEncryptKey = encryptKey;
        mExpireTimeSecond = expireTimeSecond;
    }

    public void setEncrypted(boolean encrypted) {
        mIsEncrypted = encrypted;
    }

    public void setHttps(boolean https) {
        mIsHttps = https;
    }

    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        String line;
        if (mAccountId == null || mEncryptKey == null) {
            throw new DnsException(domain.domain, "Invalid account id or encrypt key");
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(mIsHttps ? ENDPOINT_SSL : ENDPOINT + mAccountId + "/d?dn=" + (mIsEncrypted ? DES.encrypt(domain.domain, mEncryptKey) : domain.domain) + "&e=" + Integer.toString(mExpireTimeSecond) + "&s=" + MD5.encrypt(domain.domain + "-" + mEncryptKey + "-" + mExpireTimeSecond) + "&ttl=1&echo=1").openConnection();
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(10000);
        if (connection.getResponseCode() != 200) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        try {
            JSONArray result;
            JSONArray jSONArray = result = mIsEncrypted ? new JSONArray(DES.decrypt(new JSONObject(sb.toString()).optString("data"), mEncryptKey)).optJSONArray(0) : new JSONObject(sb.toString()).optJSONArray("data").optJSONArray(0);
            if (result.length() <= 0) {
                return null;
            }
            Record[] records = new Record[result.length()];
            for (int i = 0; i < records.length; ++i) {
                JSONObject item = result.optJSONObject(i);
                records[i] = new Record(item.optString("data"), 1, item.optInt("TTL"), System.currentTimeMillis() / 1000L, Record.Source.DnspodFree);
            }
            return records;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        mExpireTimeSecond = 0;
        mIsEncrypted = true;
        mIsHttps = true;
    }
}

