/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.local.DnshijackingException;
import com.qiniu.android.dns.local.Resolver;
import java.io.IOException;

public final class HijackingDetectWrapper
implements IResolver {
    private final Resolver resolver;

    public HijackingDetectWrapper(Resolver r) {
        this.resolver = r;
    }

    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        Record[] records = this.resolver.resolve(domain, info);
        if (domain.hasCname) {
            boolean cname = false;
            Record[] recordArray = records;
            int n = recordArray.length;
            for (int i = 0; i < n; ++i) {
                Record r = recordArray[i];
                if (!r.isCname()) continue;
                cname = true;
                break;
            }
            if (!cname) {
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress());
            }
        }
        if (domain.maxTtl != 0) {
            for (Record r : records) {
                if (r.isCname() || r.ttl <= domain.maxTtl) continue;
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress(), r.ttl);
            }
        }
        return records;
    }
}

