/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns;

import android.os.Build;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.Network;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.RecordSorter;
import com.qiniu.android.dns.http.DomainNotOwn;
import com.qiniu.android.dns.local.Hosts;
import com.qiniu.android.dns.util.LruCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public final class DnsManager {
    private final IResolver[] resolvers;
    private final LruCache<String, Record[]> cache;
    private final Hosts hosts = new Hosts();
    private final RecordSorter sorter;
    private volatile NetworkInfo info = null;
    private volatile int index = 0;
    public QueryErrorHandler queryErrorHandler;

    public DnsManager(NetworkInfo info, IResolver[] resolvers) {
        this(info, resolvers, null);
    }

    public DnsManager(NetworkInfo info, IResolver[] resolvers, RecordSorter sorter) {
        this.info = info == null ? NetworkInfo.normal : info;
        this.resolvers = (IResolver[])resolvers.clone();
        this.cache = new LruCache();
        this.sorter = sorter == null ? new DummySorter() : sorter;
    }

    private static Record[] trimCname(Record[] records) {
        ArrayList<Record> a = new ArrayList<Record>(records.length);
        for (Record r : records) {
            if (r == null || !r.isA() && !r.isAAAA()) continue;
            a.add(r);
        }
        return a.toArray(new Record[a.size()]);
    }

    private static String[] records2Ip(Record[] records) {
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<String> a = new ArrayList<String>(records.length);
        for (Record r : records) {
            a.add(r.value);
        }
        if (a.size() == 0) {
            return null;
        }
        return a.toArray(new String[a.size()]);
    }

    private static Record[] filterInvalidRecords(Record[] records) {
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<Record> ret = new ArrayList<Record>(records.length);
        for (Record r : records) {
            if (r == null || r.value == null || r.value.length() <= 0 || r.isExpired()) continue;
            ret.add(r);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret.toArray(new Record[ret.size()]);
    }

    public static boolean validIP(String ip) {
        if (ip == null || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        if (ip.contains("-")) {
            return false;
        }
        try {
            int x = 0;
            int y = ip.indexOf(46);
            if (y != -1 && Integer.parseInt(ip.substring(x, y)) > 255) {
                return false;
            }
            if ((x = ip.indexOf(46, ++y)) != -1 && Integer.parseInt(ip.substring(y, x)) > 255) {
                return false;
            }
            return (y = ip.indexOf(46, ++x)) == -1 || Integer.parseInt(ip.substring(x, y)) <= 255 || Integer.parseInt(ip.substring(++y, ip.length() - 1)) <= 255 || ip.charAt(ip.length() - 1) == '.';
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean needHttpDns() {
        try {
            TimeZone zone = TimeZone.getDefault();
            String id = zone.getID();
            return "Asia/Shanghai".equals(id) || "Asia/Chongqing".equals(id) || "Asia/Harbin".equals(id) || "Asia/Urumqi".equals(id);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Record[] queryRecords(String domain) throws IOException {
        return this.queryRecords(new Domain(domain));
    }

    public Record[] queryRecords(Domain domain) throws IOException {
        if (domain == null) {
            throw new IOException("null domain");
        }
        if (domain.domain == null || domain.domain.trim().length() == 0) {
            throw new IOException("empty domain " + domain.domain);
        }
        if (DnsManager.validIP(domain.domain)) {
            Record record = new Record(domain.domain, 1, -1, new Date().getTime(), 0);
            return new Record[]{record};
        }
        Record[] records = this.queryRecordInternal(domain);
        return this.sorter.sort(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Record[] queryRecordInternal(Domain domain) throws IOException {
        Record[] ret;
        if (domain.hostsFirst) {
            ret = this.hosts.query(domain, this.info);
            if ((ret = DnsManager.filterInvalidRecords(ret)) != null && ret.length > 0) {
                return ret;
            }
        }
        ret = this.cache;
        // MONITORENTER : this.cache
        if (this.info.equals(NetworkInfo.normal) && Network.isNetworkChanged()) {
            this.cache.clear();
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            this.index = 0;
            // MONITOREXIT : iResolverArray
        } else {
            Record[] records = (Record[])this.cache.get(domain.domain);
            if ((records = DnsManager.filterInvalidRecords(records)) != null && records.length > 0) {
                // MONITOREXIT : ret
                return records;
            }
        }
        // MONITOREXIT : ret
        Record[] records = null;
        IOException lastE = null;
        int firstOk = this.index;
        for (int i = 0; i < this.resolvers.length; ++i) {
            String ip;
            NetworkInfo before;
            block27: {
                int pos = (firstOk + i) % this.resolvers.length;
                before = this.info;
                ip = Network.getIp();
                try {
                    records = this.resolvers[pos].resolve(domain, this.info);
                }
                catch (DomainNotOwn e) {
                    continue;
                }
                catch (IOException e) {
                    lastE = e;
                    e.printStackTrace();
                    if (this.queryErrorHandler != null) {
                        this.queryErrorHandler.queryError(e, domain.domain);
                    }
                }
                catch (Exception e2) {
                    if (Build.VERSION.SDK_INT >= 9) {
                        lastE = new IOException(e2);
                    }
                    e2.printStackTrace();
                    if (this.queryErrorHandler == null) break block27;
                    this.queryErrorHandler.queryError(e2, domain.domain);
                }
            }
            String ip2 = Network.getIp();
            if (this.info != before || records != null && records.length != 0 || !ip.equals(ip2)) break;
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            if (this.index == firstOk) {
                ++this.index;
                if (this.index == this.resolvers.length) {
                    this.index = 0;
                }
            }
            // MONITOREXIT : iResolverArray
        }
        if (records == null || records.length == 0) {
            if (!domain.hostsFirst) {
                Record[] rs = this.hosts.query(domain, this.info);
                if ((rs = DnsManager.filterInvalidRecords(rs)) != null && rs.length != 0) {
                    return rs;
                }
            }
            if (lastE != null) {
                throw lastE;
            }
            UnknownHostException e = new UnknownHostException(domain.domain);
            if (this.queryErrorHandler == null) throw e;
            this.queryErrorHandler.queryError(e, domain.domain);
            throw e;
        }
        if ((records = DnsManager.trimCname(records)).length == 0) {
            throw new UnknownHostException("no A/AAAA records");
        }
        LruCache<String, Record[]> lruCache = this.cache;
        // MONITORENTER : lruCache
        this.cache.put(domain.domain, records);
        // MONITOREXIT : lruCache
        return records;
    }

    public InetAddress[] queryInetAdress(Domain domain) throws IOException {
        Record[] records = this.queryRecords(domain);
        String[] ips = DnsManager.records2Ip(records);
        if (ips == null || ips.length == 0) {
            return null;
        }
        InetAddress[] addresses = new InetAddress[ips.length];
        for (int i = 0; i < ips.length; ++i) {
            addresses[i] = InetAddress.getByName(ips[i]);
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkChange(NetworkInfo info) {
        this.clearCache();
        this.info = info == null ? NetworkInfo.normal : info;
        IResolver[] iResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            this.index = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        LruCache<String, Record[]> lruCache = this.cache;
        synchronized (lruCache) {
            this.cache.clear();
        }
    }

    public DnsManager putHosts(String domain, Record record, int provider) {
        Record recordNew = new Record(record.value, record.type, record.ttl, record.timeStamp, 1, record.server);
        this.hosts.put(domain, new Hosts.Value(recordNew, provider));
        return this;
    }

    public DnsManager putHosts(String domain, int type, String ip, int provider) {
        this.putHosts(domain, new Record(ip, type, -1, new Date().getTime() / 1000L, 1), provider);
        return this;
    }

    public DnsManager putHosts(String domain, int type, String ip) {
        this.putHosts(domain, type, ip, 0);
        return this;
    }

    public DnsManager putHosts(String domain, String ipv4) {
        this.putHosts(domain, 1, ipv4);
        return this;
    }

    public static interface QueryErrorHandler {
        public void queryError(Exception var1, String var2);
    }

    private static class DummySorter
    implements RecordSorter {
        private AtomicInteger pos = new AtomicInteger();

        private DummySorter() {
        }

        @Override
        public Record[] sort(Record[] records) {
            return records;
        }
    }
}

