/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.dns;

import com.qiniu.android.dns.dns.DnsMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.IDN;

class DnsRequest
extends DnsMessage {
    private final int recordType;
    private final String host;

    int getRecordType() {
        return this.recordType;
    }

    String getHost() {
        return this.host;
    }

    DnsRequest(short messageId, int recordType, String host) {
        this(messageId, 0, 1, recordType, host);
    }

    DnsRequest(short messageId, int opCode, int rd, int recordType, String host) {
        this.messageId = messageId;
        this.opCode = opCode;
        this.rd = rd;
        this.recordType = recordType;
        this.host = host;
    }

    byte[] toDnsQuestionData() throws IOException {
        if (this.host == null || this.host.length() == 0) {
            throw new IOException("host can not empty");
        }
        if (this.opCode != 0 && this.opCode != 1 && this.opCode != 2 && this.opCode != 5) {
            throw new IOException("opCode is not valid");
        }
        if (this.rd != 0 && this.rd != 1) {
            throw new IOException("rd is not valid");
        }
        if (this.recordType != 1 && this.recordType != 28 && this.recordType != 5 && this.recordType != 16) {
            throw new IOException("recordType is not valid");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(this.messageId);
        dos.writeByte((this.opCode << 3) + this.rd);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(0);
        for (String s : this.host.split("[.\u3002\uff0e\uff61]")) {
            if (s.length() > 63) {
                throw new IOException("host part is too long");
            }
            byte[] buffer = IDN.toASCII(s).getBytes();
            dos.write(buffer.length);
            dos.write(buffer, 0, buffer.length);
        }
        dos.writeByte(0);
        dos.writeByte(0);
        dos.writeByte(this.recordType);
        dos.writeByte(0);
        dos.writeByte(1);
        return baos.toByteArray();
    }
}

