/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.dns;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.dns.DnsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class DnsResolver
implements IResolver {
    private static ScheduledExecutorService timeoutExecutorService = Executors.newSingleThreadScheduledExecutor();
    private static ExecutorService defaultExecutorService = new ThreadPoolExecutor(0, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final int recordType;
    private final String[] servers;
    private final ExecutorService executorService;
    protected final int timeout;

    public DnsResolver(String server) {
        this(server, 1, 10);
    }

    public DnsResolver(String server, int timeout) {
        this(server, 1, timeout);
    }

    public DnsResolver(String server, int recordType, int timeout) {
        String[] stringArray;
        if (server == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = server;
        }
        this(stringArray, recordType, timeout, null);
    }

    public DnsResolver(String[] servers, int recordType, int timeout) {
        this(servers, recordType, timeout, servers != null && servers.length > 0 ? defaultExecutorService : null);
    }

    public DnsResolver(String[] servers, int recordType, int timeout, ExecutorService executorService) {
        this.recordType = recordType;
        this.timeout = timeout > 0 ? timeout : 10;
        this.servers = servers;
        this.executorService = executorService;
    }

    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        DnsResponse response = this.lookupHost(domain.domain);
        if (response == null) {
            throw new IOException("response is null");
        }
        List<Record> answers = response.getAnswerArray();
        if (answers == null || answers.size() == 0) {
            return null;
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record record : answers) {
            if (!record.isA() && !record.isCname() && !record.isAAAA()) continue;
            records.add(record);
        }
        return records.toArray(new Record[0]);
    }

    private DnsResponse lookupHost(String host) throws IOException {
        return this.request(host, this.recordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DnsResponse request(final String host, final int recordType) throws IOException {
        if (this.servers == null || this.servers.length == 0) {
            throw new IOException("server can not empty");
        }
        if (host == null || host.length() == 0) {
            throw new IOException("host can not empty");
        }
        if (this.servers.length == 1 || this.executorService == null) {
            String server;
            DnsResponse response = null;
            String[] stringArray = this.servers;
            int n = stringArray.length;
            for (int i = 0; i < n && (response = this.request(server = stringArray[i], host, recordType)) == null; ++i) {
            }
            return response;
        }
        final DnsResponse[] response = new DnsResponse[]{null};
        final IOException[] exceptions = new IOException[]{null};
        final int[] completedCount = new int[]{0};
        final Object waiter = new Object();
        timeoutExecutorService.schedule(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Object object = waiter;
                synchronized (object) {
                    waiter.notify();
                    exceptions[0] = new IOException("resolver timeout for server:" + DnsResolver.this.servers.toString() + " host:" + host);
                }
                return null;
            }
        }, (long)this.timeout, TimeUnit.SECONDS);
        Object object = this.servers;
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String server;
            final String serverP = server = object[i];
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = waiter;
                    synchronized (object) {
                        try {
                            response[0] = DnsResolver.this.request(serverP, host, recordType);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            exceptions[0] = new IOException(e);
                        }
                        completedCount[0] = completedCount[0] + 1;
                        if (completedCount[0] == DnsResolver.this.servers.length || response[0] != null) {
                            waiter.notify();
                        }
                    }
                }
            });
        }
        object = waiter;
        synchronized (object) {
            try {
                waiter.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        return response[0];
    }

    abstract DnsResponse request(String var1, String var2, int var3) throws IOException;
}

