/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.dns.DnsUdpResolver;
import com.qiniu.android.dns.local.DnshijackingException;
import com.qiniu.android.dns.local.HijackingDetectWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AndroidDnsServer {
    public static List<InetAddress> getByCommand() {
        try {
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
            String line = null;
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            while ((line = lnr.readLine()) != null) {
                InetAddress ip;
                int split = line.indexOf("]: [");
                if (split <= 1 || line.length() - 1 <= split + 4) continue;
                String property = line.substring(1, split);
                String value = line.substring(split + 4, line.length() - 1);
                if (!property.endsWith(".dns") && !property.endsWith(".dns1") && !property.endsWith(".dns2") && !property.endsWith(".dns3") && !property.endsWith(".dns4") || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers;
            }
        }
        catch (IOException e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByExec", e);
        }
        return null;
    }

    public static List<InetAddress> getByReflection() {
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            for (String propKey : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                InetAddress ip;
                String value = (String)method.invoke(null, propKey);
                if (value == null || value.length() == 0 || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0 || servers.contains(ip)) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers;
            }
        }
        catch (Exception e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByReflection", e);
        }
        return null;
    }

    public static IResolver defaultResolver(Context context) {
        return new AndroidResolver(context);
    }

    static class AndroidResolver
    implements IResolver {
        private List<InetAddress> dnsServers = new ArrayList<InetAddress>();
        private boolean networkCallback = false;

        @TargetApi(value=21)
        AndroidResolver(Context context) {
            List<InetAddress> addresses = AndroidDnsServer.getByReflection();
            if (addresses == null) {
                addresses = AndroidDnsServer.getByCommand();
            }
            if (addresses == null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkRequest.Builder builder = new NetworkRequest.Builder();
                    if (connectivityManager != null) {
                        try {
                            connectivityManager.registerNetworkCallback(builder.build(), new ConnectivityManager.NetworkCallback(){

                                public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
                                    if (linkProperties != null) {
                                        AndroidResolver.this.dnsServers.addAll(linkProperties.getDnsServers());
                                    }
                                    AndroidResolver.this.networkCallback = true;
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                this.dnsServers.addAll(addresses);
            }
        }

        @Override
        public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
            if (this.dnsServers.isEmpty() && !this.networkCallback) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.dnsServers == null || this.dnsServers.isEmpty()) {
                throw new IOException("cant get local dns server");
            }
            InetAddress dnsServer = this.dnsServers.get(0);
            HijackingDetectWrapper resolver = new HijackingDetectWrapper(new DnsUdpResolver(dnsServer.getHostName()));
            Record[] records = resolver.resolve(domain, info);
            if (domain.hasCname) {
                boolean cname = false;
                Record[] recordArray = records;
                int n = recordArray.length;
                for (int i = 0; i < n; ++i) {
                    Record r = recordArray[i];
                    if (!r.isCname()) continue;
                    cname = true;
                    break;
                }
                if (!cname) {
                    throw new DnshijackingException(domain.domain, dnsServer.getHostAddress());
                }
            }
            if (domain.maxTtl != 0) {
                for (Record r : records) {
                    if (r.isCname() || r.ttl <= domain.maxTtl) continue;
                    throw new DnshijackingException(domain.domain, dnsServer.getHostAddress(), r.ttl);
                }
            }
            return records;
        }
    }
}

