/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Hosts {
    private final Map<String, LinkedList<Value>> hosts = new ConcurrentHashMap<String, LinkedList<Value>>();

    public synchronized Record[] query(Domain domain, NetworkInfo info) {
        LinkedList<Value> values = this.hosts.get(domain.domain);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            Value first = values.get(0);
            values.remove(0);
            values.add(first);
        }
        values = this.filter(values, info);
        return this.toRecords(values);
    }

    private LinkedList<Value> filter(LinkedList<Value> origin, NetworkInfo info) {
        if (origin == null) {
            return null;
        }
        LinkedList<Value> normal = new LinkedList<Value>();
        LinkedList<Value> special = new LinkedList<Value>();
        for (Value v : origin) {
            if (v.provider == 0) {
                normal.add(v);
                continue;
            }
            if (v.provider != info.provider) continue;
            special.add(v);
        }
        if (special.size() != 0) {
            return special;
        }
        return normal;
    }

    private Record[] toRecords(LinkedList<Value> vals) {
        if (vals == null) {
            return null;
        }
        int size = vals.size();
        ArrayList<Record> records = new ArrayList<Record>();
        for (int i = 0; i < size; ++i) {
            Value v = vals.get(i);
            if (v == null || v.record == null || v.record.value == null) continue;
            records.add(v.record);
        }
        return records.toArray(new Record[records.size()]);
    }

    public synchronized Hosts put(String domain, Value val) {
        LinkedList<Value> vals = this.hosts.get(domain);
        if (vals == null) {
            vals = new LinkedList();
        }
        vals.add(val);
        this.hosts.put(domain, vals);
        return this;
    }

    public Hosts put(String domain, Record record) {
        this.put(domain, new Value(record));
        return this;
    }

    public static class Value {
        public final Record record;
        public final int provider;

        public Value(Record record, int provider) {
            this.record = record;
            this.provider = provider;
        }

        public Value(Record record) {
            this(record, 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value another = (Value)o;
            if (this.record == another.record) {
                return true;
            }
            if (this.record == null || another.record == null) {
                return false;
            }
            return this.record.value.equals(another.record.value) && this.provider == another.provider;
        }
    }
}

