/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns;

import java.util.Date;
import java.util.Locale;

public final class Record {
    public static final int TTL_MIN_SECONDS = 600;
    public static final int TTL_Forever = -1;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_TXT = 16;
    public final String value;
    public final int type;
    public final int ttl;
    public final long timeStamp;
    public final int source;
    public final String server;

    public Record(String value, int type, int ttl) {
        this.value = value;
        this.type = type;
        this.ttl = ttl;
        this.timeStamp = new Date().getTime() / 1000L;
        this.source = 0;
        this.server = null;
    }

    public Record(String value, int type, int ttl, long timeStamp, int source) {
        this.value = value;
        this.type = type;
        this.ttl = Math.max(ttl, 600);
        this.timeStamp = timeStamp;
        this.source = source;
        this.server = null;
    }

    public Record(String value, int type, int ttl, long timeStamp, int source, String server) {
        this.value = value;
        this.type = type;
        this.ttl = ttl < 600 ? 600 : ttl;
        this.timeStamp = timeStamp;
        this.source = source;
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Record)) {
            return false;
        }
        Record another = (Record)o;
        return this.value.equals(another.value) && this.type == another.type && this.ttl == another.ttl && this.timeStamp == another.timeStamp;
    }

    public boolean isA() {
        return this.type == 1;
    }

    public boolean isAAAA() {
        return this.type == 28;
    }

    public boolean isCname() {
        return this.type == 5;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis() / 1000L);
    }

    public boolean isExpired(long time) {
        if (this.ttl == -1) {
            return false;
        }
        return this.timeStamp + (long)this.ttl < time;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "{type:%s, value:%s, source:%s, server:%s, timestamp:%d, ttl:%d}", this.type, this.value, this.source, this.server, this.timeStamp, this.ttl);
    }

    public static class Source {
        public static final int Unknown = 0;
        public static final int Custom = 1;
        public static final int DnspodEnterprise = 2;
        public static final int System = 3;
        public static final int Udp = 4;
        public static final int Doh = 5;
    }
}

