/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.dns;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.dns.DnsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class DnsResolver
implements IResolver {
    private static ScheduledExecutorService timeoutExecutorService = Executors.newSingleThreadScheduledExecutor();
    private static ExecutorService defaultExecutorService = Executors.newFixedThreadPool(4);
    private final int recordType;
    private final String[] servers;
    private final ExecutorService executorService;
    protected final int timeout;

    public DnsResolver(String server) {
        this(server, 1, 10);
    }

    public DnsResolver(String server, int timeout) {
        this(server, 1, timeout);
    }

    public DnsResolver(String server, int recordType, int timeout) {
        String[] stringArray;
        if (server == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = server;
        }
        this(stringArray, recordType, timeout, null);
    }

    public DnsResolver(String[] servers, int recordType, int timeout) {
        this.recordType = recordType;
        this.timeout = timeout > 0 ? timeout : 10;
        this.servers = servers;
        this.executorService = null;
    }

    public DnsResolver(String[] servers, int recordType, int timeout, ExecutorService executorService) {
        if (servers != null && servers.length > 1 && executorService == null) {
            executorService = defaultExecutorService;
        }
        this.recordType = recordType;
        this.timeout = timeout > 0 ? timeout : 10;
        this.servers = servers;
        this.executorService = executorService;
    }

    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        DnsResponse response = this.lookupHost(domain.domain);
        if (response == null) {
            throw new IOException("response is null");
        }
        List<Record> answers = response.getAnswerArray();
        if (answers == null || answers.size() == 0) {
            return null;
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record record : answers) {
            if (!record.isA() && !record.isCname() && !record.isAAAA()) continue;
            records.add(record);
        }
        return records.toArray(new Record[0]);
    }

    private DnsResponse lookupHost(String host) throws IOException {
        return this.request(host, this.recordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DnsResponse request(final String host, final int recordType) throws IOException {
        if (this.servers == null || this.servers.length == 0) {
            throw new IOException("server can not empty");
        }
        if (host == null || host.length() == 0) {
            throw new IOException("host can not empty");
        }
        final RequestCanceller canceller = new RequestCanceller();
        if (this.servers.length == 1 || this.executorService == null) {
            String server;
            DnsResponse response = null;
            String[] stringArray = this.servers;
            int n = stringArray.length;
            for (int i = 0; i < n && (response = this.request(canceller, server = stringArray[i], host, recordType)) == null; ++i) {
            }
            return response;
        }
        final ResponseComposition responseComposition = new ResponseComposition();
        timeoutExecutorService.schedule(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                ResponseComposition responseComposition2 = responseComposition;
                synchronized (responseComposition2) {
                    responseComposition.notify();
                    responseComposition.exception = new IOException("resolver timeout for server:" + DnsResolver.this.servers + " host:" + host);
                }
                return null;
            }
        }, (long)this.timeout, TimeUnit.SECONDS);
        ArrayList futures = new ArrayList();
        for (final String server : this.servers) {
            Future<?> future = this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DnsResponse response = null;
                    IOException exception = null;
                    try {
                        response = DnsResolver.this.request(canceller, server, host, recordType);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exception = new IOException(e);
                    }
                    ResponseComposition responseComposition2 = responseComposition;
                    synchronized (responseComposition2) {
                        ++responseComposition.completedCount;
                        if (responseComposition.response == null) {
                            responseComposition.response = response;
                        }
                        if (responseComposition.exception == null) {
                            responseComposition.exception = exception;
                        }
                        if (responseComposition.completedCount == DnsResolver.this.servers.length || responseComposition.response != null) {
                            responseComposition.notify();
                        }
                    }
                }
            });
            futures.add(future);
        }
        ResponseComposition responseComposition2 = responseComposition;
        synchronized (responseComposition2) {
            try {
                responseComposition.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        canceller.cancel();
        if (responseComposition.exception != null && responseComposition.response == null) {
            throw responseComposition.exception;
        }
        return responseComposition.response;
    }

    abstract DnsResponse request(RequestCanceller var1, String var2, String var3, int var4) throws IOException;

    static class RequestCanceller {
        Queue<Runnable> cancelActions = new ConcurrentLinkedQueue<Runnable>();

        RequestCanceller() {
        }

        void addCancelAction(Runnable cancelAction) {
            if (cancelAction != null) {
                this.cancelActions.add(cancelAction);
            }
        }

        void cancel() {
            for (Runnable cancelAction : this.cancelActions) {
                if (cancelAction == null) continue;
                cancelAction.run();
            }
        }
    }

    private static class ResponseComposition {
        DnsResponse response;
        IOException exception;
        int completedCount = 0;

        ResponseComposition() {
        }
    }
}

