/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.dns;

import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.dns.DnsMessage;
import com.qiniu.android.dns.dns.DnsRequest;
import java.io.IOException;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

class DnsResponse
extends DnsMessage {
    private long timestamp;
    private int source;
    private String server;
    private DnsRequest request;
    private byte[] recordData;
    private int aa;
    private int rCode;
    private List<Record> answerArray;
    private List<Record> authorityArray;
    private List<Record> additionalArray;

    DnsResponse(String server, int source, DnsRequest request, byte[] recordData) throws IOException {
        if (recordData == null || recordData.length == 0) {
            throw new IOException("response data is empty");
        }
        this.server = server;
        this.source = source;
        this.request = request;
        this.recordData = recordData;
        this.timestamp = new Date().getTime() / 1000L;
        this.parse();
    }

    private void parse() throws IOException {
        if (this.recordData.length < 12) {
            throw new IOException("response data too small");
        }
        this.parseHeader();
        int index = this.parseQuestion();
        RecordResource answer = new RecordResource("answer", this.readRecordDataInt16(6), index);
        this.parseResourceRecord(answer);
        this.answerArray = answer.records;
        RecordResource authority = new RecordResource("authority", this.readRecordDataInt16(8), index += answer.length);
        this.parseResourceRecord(authority);
        this.authorityArray = authority.records;
        RecordResource additional = new RecordResource("additional", this.readRecordDataInt16(10), index += authority.length);
        this.parseResourceRecord(additional);
        this.additionalArray = additional.records;
    }

    private void parseHeader() throws IOException {
        this.messageId = this.readRecordDataInt16(0);
        if (this.messageId != this.request.messageId) {
            throw new IOException("question id error");
        }
        int field0 = this.readRecordDataInt8(2);
        int qr = this.readRecordDataInt8(2) & 0x80;
        if (qr == 0) {
            throw new IOException("not a response data");
        }
        this.opCode = field0 >> 3 & 7;
        this.aa = field0 >> 2 & 1;
        this.rd = field0 & 1;
        int field1 = this.readRecordDataInt8(3);
        this.ra = field1 >> 7 & 1;
        this.rCode = field1 & 0xF;
    }

    private int parseQuestion() throws IOException {
        int index = 12;
        for (int qdCount = this.readRecordDataInt16(4); qdCount > 0; --qdCount) {
            RecordName recordName = this.getNameFrom(index);
            if (recordName == null) {
                throw new IOException("read Question error");
            }
            index += recordName.skipLength + 4;
        }
        return index;
    }

    private void parseResourceRecord(RecordResource resource) throws IOException {
        int index = resource.from;
        for (int count = resource.count; count > 0; --count) {
            RecordName recordName = this.getNameFrom(index);
            if (recordName == null) {
                throw new IOException("read " + resource.name + " error");
            }
            short type = this.readRecordDataInt16(index += recordName.skipLength);
            short clazz = this.readRecordDataInt16(index += 2);
            int ttl = this.readRecordDataInt32(index += 2);
            short rdLength = this.readRecordDataInt16(index += 4);
            String value = this.readData(type, index += 2, rdLength);
            if (clazz == 1 && (type == 5 || type == this.request.getRecordType())) {
                Record record = new Record(value, type, ttl, this.timestamp, this.source, this.server);
                resource.addRecord(record);
            }
            index += rdLength;
        }
        resource.length = index - resource.from;
    }

    private RecordName getNameFrom(int from) throws IOException {
        int partLength = 0;
        int index = from;
        StringBuilder name = new StringBuilder();
        RecordName recordName = new RecordName();
        int maxLoop = 128;
        do {
            if (((partLength = this.readRecordDataInt8(index)) & 0xC0) == 192) {
                if (recordName.skipLength < 1) {
                    recordName.skipLength = index + 2 - from;
                }
                index = (partLength & 0x3F) << 8 | this.readRecordDataInt8(index + 1);
                continue;
            }
            if ((partLength & 0xC0) > 0) {
                return null;
            }
            ++index;
            if (partLength <= 0) continue;
            if (name.length() > 0) {
                name.append(".");
            }
            byte[] nameData = Arrays.copyOfRange(this.recordData, index, index + partLength);
            name.append(IDN.toUnicode(new String(nameData)));
            index += partLength;
        } while (partLength > 0 && --maxLoop > 0);
        recordName.name = name.toString();
        if (recordName.skipLength < 1) {
            recordName.skipLength = index - from;
        }
        return recordName;
    }

    private String readData(int recordType, int from, int length) throws IOException {
        String dataString = null;
        switch (recordType) {
            case 1: {
                if (length != 4) break;
                StringBuilder builder = new StringBuilder();
                builder.append(this.readRecordDataInt8(from));
                for (int i = 1; i < 4; ++i) {
                    builder.append(".");
                    builder.append(this.readRecordDataInt8(from + i));
                }
                dataString = builder.toString();
                break;
            }
            case 28: {
                if (length != 16) break;
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < 16; i += 2) {
                    builder.append(i > 0 ? ":" : "");
                    builder.append(this.readRecordDataInt8(from + i));
                    builder.append(this.readRecordDataInt8(from + i + 1));
                }
                dataString = builder.toString();
                break;
            }
            case 5: {
                if (length <= 1) break;
                RecordName name = this.getNameFrom(from);
                dataString = name.name;
                break;
            }
            case 16: {
                if (length <= 0 || from + length >= this.recordData.length) break;
                byte[] data = Arrays.copyOfRange(this.recordData, from, from + length);
                String dataValue = new String(data);
                dataString = IDN.toUnicode(dataValue);
                break;
            }
        }
        return dataString;
    }

    private int readRecordDataInt8(int from) throws IOException {
        if (from >= this.recordData.length) {
            throw new IOException("read response data out of range");
        }
        return this.recordData[from] & 0xFF;
    }

    private short readRecordDataInt16(int from) throws IOException {
        if (from + 1 >= this.recordData.length) {
            throw new IOException("read response data out of range");
        }
        int b0 = (this.recordData[from] & 0xFF) << 8;
        int b1 = this.recordData[from + 1] & 0xFF;
        return (short)(b0 + b1);
    }

    private int readRecordDataInt32(int from) throws IOException {
        if (from + 3 >= this.recordData.length) {
            throw new IOException("read response data out of range");
        }
        int b0 = (this.recordData[from] & 0xFF) << 24;
        int b1 = (this.recordData[from + 1] & 0xFF) << 16;
        int b2 = (this.recordData[from + 2] & 0xFF) << 8;
        int b3 = this.recordData[from + 3] & 0xFF;
        return b0 + b1 + b2 + b3;
    }

    int getAA() {
        return this.aa;
    }

    int getRCode() {
        return this.rCode;
    }

    List<Record> getAnswerArray() {
        return this.answerArray;
    }

    List<Record> getAdditionalArray() {
        return this.additionalArray;
    }

    List<Record> getAuthorityArray() {
        return this.authorityArray;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "{messageId:%d, rd:%d, ra:%d, aa:%d, rCode:%d, server:%s, request:%s, answerArray:%s, authorityArray:%s, additionalArray:%s}", this.messageId, this.rd, this.ra, this.aa, this.rCode, this.server, this.request, this.answerArray, this.authorityArray, this.additionalArray);
    }

    private static class RecordName {
        private int skipLength;
        private String name;

        private RecordName() {
        }
    }

    private static class RecordResource {
        private final String name;
        private final int count;
        private final int from;
        private int length;
        private final List<Record> records;

        private RecordResource(String name, int count, int from) {
            this.name = name;
            this.count = count;
            this.from = from;
            this.length = 0;
            this.records = new ArrayList<Record>();
        }

        private void addRecord(Record record) {
            if (record != null) {
                this.records.add(record);
            }
        }
    }
}

