/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public final class ByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;

    public ByteArrayEntity(byte[] b) {
        this.b = b;
        this.off = 0;
        this.len = this.b.length;
    }

    public ByteArrayEntity(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        this.b = b;
        this.off = off;
        this.len = len;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.len;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.b, this.off, this.len);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

