/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.qiniu.android.http.ByteArrayEntity;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.PostArgs;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseHandler;
import com.qiniu.android.http.ResponseInfo;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public final class HttpManager {
    private static final String userAgent = HttpManager.getUserAgent();
    private AsyncHttpClient client = new AsyncHttpClient();

    public HttpManager() {
        this.client.setConnectTimeout(10000);
        this.client.setResponseTimeout(30000);
        this.client.setUserAgent(userAgent);
        this.client.setEnableRedirects(false);
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    private static String getUserAgent() {
        return String.format("QiniuAndroid/%s (%s; %s; %s)", "7.0.1", Build.VERSION.RELEASE, Build.MODEL, HttpManager.genId());
    }

    public void postData(String url, byte[] data, int offset, int size, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        ResponseHandler handler = new ResponseHandler(completionHandler, progressHandler);
        ByteArrayEntity entity = new ByteArrayEntity(data, offset, size);
        this.client.post(null, url, headers, (HttpEntity)entity, "application/octet-stream", (ResponseHandlerInterface)handler);
    }

    public void postData(String url, byte[] data, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        this.postData(url, data, 0, data.length, headers, progressHandler, completionHandler);
    }

    public void multipartPost(String url, PostArgs args, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        RequestParams requestParams = new RequestParams(args.params);
        if (args.data != null) {
            ByteArrayInputStream buff = new ByteArrayInputStream(args.data);
            requestParams.put("file", (InputStream)buff, args.fileName, args.mimeType);
        } else {
            try {
                requestParams.put("file", args.file, args.mimeType);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                completionHandler.complete(ResponseInfo.fileError(e), null);
                return;
            }
        }
        ResponseHandler handler = new ResponseHandler(completionHandler, progressHandler);
        this.client.post(url, requestParams, (ResponseHandlerInterface)handler);
    }
}

