/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Looper;
import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseHandler
extends AsyncHttpResponseHandler {
    private ProgressHandler progressHandler;
    private CompletionHandler completionHandler;

    public ResponseHandler(CompletionHandler completionHandler, ProgressHandler progressHandler) {
        super(Looper.getMainLooper());
        this.completionHandler = completionHandler;
        this.progressHandler = progressHandler;
    }

    private static ResponseInfo buildResponseInfo(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String reqId = null;
        String xlog = null;
        if (headers != null) {
            for (Header h : headers) {
                if ("X-Reqid".equals(h.getName())) {
                    reqId = h.getValue();
                    continue;
                }
                if (!"X-Log".equals(h.getName())) continue;
                xlog = h.getValue();
            }
        }
        String err = null;
        if (statusCode != 200) {
            if (responseBody != null) {
                try {
                    err = new String(responseBody, "utf-8");
                    JSONObject obj = new JSONObject(err);
                    err = obj.optString("error", err);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (error != null && (err = error.getMessage()) == null) {
                err = error.toString();
            }
        } else if (reqId == null) {
            err = "remote is not qiniu server!";
        }
        if (statusCode == 0) {
            statusCode = -1;
        }
        return new ResponseInfo(statusCode, reqId, xlog, err);
    }

    private static JSONObject buildJsonResp(byte[] body) throws Exception {
        String str = new String(body, "utf-8");
        return new JSONObject(str);
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        JSONObject obj = null;
        Exception exception = null;
        try {
            obj = ResponseHandler.buildJsonResp(responseBody);
        }
        catch (Exception e) {
            exception = e;
        }
        ResponseInfo info = ResponseHandler.buildResponseInfo(statusCode, headers, null, exception);
        Log.i((String)"qiniu----success", (String)info.toString());
        this.completionHandler.complete(info, obj);
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        ResponseInfo info = ResponseHandler.buildResponseInfo(statusCode, headers, responseBody, error);
        Log.i((String)"qiniu----failed", (String)info.toString());
        this.completionHandler.complete(info, null);
    }

    public void onProgress(int bytesWritten, int totalSize) {
        if (this.progressHandler != null) {
            this.progressHandler.onProgress(bytesWritten, totalSize);
        }
    }

    public void onStart() {
        super.onStart();
    }
}

