/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import java.util.Locale;

public final class ResponseInfo {
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String error;

    public ResponseInfo(int statusCode, String reqId, String xlog, String error) {
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.error = error;
    }

    public static ResponseInfo cancelled() {
        return new ResponseInfo(-2, "", "", "cancelled by user");
    }

    public static ResponseInfo invalidArgument(String message) {
        return new ResponseInfo(-4, "", "", message);
    }

    public static ResponseInfo fileError(Exception e) {
        return new ResponseInfo(-3, "", "", e.getMessage());
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && this.reqId != null;
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needRetry() {
        return this.isNetworkBroken() || this.isServerError() || this.statusCode == 406 || this.statusCode == 200 && this.error != null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ResponseInfo:%s,status:%d, reqId:%s, xlog:%s,error:%s}", super.toString(), this.statusCode, this.reqId, this.xlog, this.error);
    }
}

