/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import com.qiniu.android.http.ByteArrayEntity;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.IReport;
import com.qiniu.android.http.MultipartBuilder;
import com.qiniu.android.http.PostArgs;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.Proxy;
import com.qiniu.android.http.ResponseHandler;
import com.qiniu.android.http.ResponseInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONObject;

public final class HttpManager {
    private static final String userAgent = HttpManager.getUserAgent();
    private AsyncHttpClient client;
    private IReport reporter;
    private String backUpIp;

    public HttpManager(Proxy proxy) {
        this(proxy, null);
    }

    public HttpManager(Proxy proxy, IReport reporter) {
        this(proxy, reporter, null);
    }

    public HttpManager(Proxy proxy, IReport reporter, String backUpIp) {
        this.backUpIp = backUpIp;
        this.client = new AsyncHttpClient();
        this.client.setConnectTimeout(10000);
        this.client.setResponseTimeout(30000);
        this.client.setUserAgent(userAgent);
        this.client.setEnableRedirects(false);
        if (proxy != null) {
            this.client.setProxy(proxy.hostAddress, proxy.port, proxy.user, proxy.password);
        }
        this.reporter = reporter;
        if (reporter == null) {
            this.reporter = new IReport(){

                @Override
                public Header[] appendStatHeaders(Header[] headers) {
                    return headers;
                }

                @Override
                public void updateErrorInfo(ResponseInfo info) {
                }

                @Override
                public void updateSpeedInfo(ResponseInfo info) {
                }
            };
        }
    }

    public HttpManager() {
        this(null);
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    private static String getUserAgent() {
        return String.format("QiniuAndroid/%s (%s; %s; %s)", "7.0.3", Build.VERSION.RELEASE, Build.MODEL, HttpManager.genId());
    }

    public void postData(String url, byte[] data, int offset, int size, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        ByteArrayEntity entity = new ByteArrayEntity(data, offset, size, progressHandler);
        this.postEntity(url, (HttpEntity)entity, headers, progressHandler, completionHandler);
    }

    public void postData(String url, byte[] data, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        this.postData(url, data, 0, data.length, headers, progressHandler, completionHandler);
    }

    private void postEntity(final String url, final HttpEntity entity, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        final CompletionHandler wrapper = this.wrap(completionHandler);
        final Header[] h = this.reporter.appendStatHeaders(headers);
        final ResponseHandler originHandler = new ResponseHandler(url, wrapper, progressHandler);
        if (this.backUpIp == null) {
            this.client.post(null, url, h, entity, null, (ResponseHandlerInterface)originHandler);
            return;
        }
        this.client.post(null, url, h, entity, null, (ResponseHandlerInterface)new ResponseHandler(url, new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.statusCode != -1003) {
                    wrapper.complete(info, response);
                    return;
                }
                Header[] h2 = new Header[h.length + 1];
                System.arraycopy(h, 0, h2, 0, h.length);
                URI uri = URI.create(url);
                String newUrl = null;
                try {
                    newUrl = new URI(uri.getScheme(), null, HttpManager.this.backUpIp, uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
                h2[h.length] = new BasicHeader("Host", uri.getHost());
                HttpManager.this.client.post(null, newUrl, h2, entity, null, (ResponseHandlerInterface)originHandler);
            }
        }, progressHandler));
    }

    public void multipartPost(String url, PostArgs args, ProgressHandler progressHandler, CompletionHandler completionHandler) {
        MultipartBuilder mbuilder = new MultipartBuilder();
        for (Map.Entry<String, String> entry : args.params.entrySet()) {
            mbuilder.addPart(entry.getKey(), entry.getValue());
        }
        if (args.data != null) {
            ByteArrayInputStream buff = new ByteArrayInputStream(args.data);
            try {
                mbuilder.addPart("file", args.fileName, buff, args.mimeType);
            }
            catch (IOException e) {
                completionHandler.complete(ResponseInfo.fileError(e), null);
                return;
            }
        }
        try {
            mbuilder.addPart("file", args.file, args.mimeType, "filename");
        }
        catch (IOException e) {
            completionHandler.complete(ResponseInfo.fileError(e), null);
            return;
        }
        ByteArrayEntity entity = mbuilder.build(progressHandler);
        Header[] h = this.reporter.appendStatHeaders(new Header[0]);
        this.postEntity(url, (HttpEntity)entity, h, progressHandler, completionHandler);
    }

    private CompletionHandler wrap(final CompletionHandler completionHandler) {
        return new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                completionHandler.complete(info, response);
                if (info.isOK()) {
                    HttpManager.this.reporter.updateSpeedInfo(info);
                } else {
                    HttpManager.this.reporter.updateErrorInfo(info);
                }
            }
        };
    }

    private static String escapeMultipartString(String key) {
        StringBuilder target = new StringBuilder();
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target.append("%0A");
                    continue block5;
                }
                case '\r': {
                    target.append("%0D");
                    continue block5;
                }
                case '\"': {
                    target.append("%22");
                    continue block5;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        return target.toString();
    }
}

