/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.utils.Dns;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseHandler
extends AsyncHttpResponseHandler {
    private String host;
    private ProgressHandler progressHandler;
    private CompletionHandler completionHandler;
    private long reqStartTime;
    private String ip = null;

    public ResponseHandler(String url, CompletionHandler completionHandler, ProgressHandler progressHandler) {
        super(Looper.getMainLooper());
        URI uri = null;
        try {
            uri = new URI(url);
            this.host = uri.getHost();
        }
        catch (URISyntaxException e) {
            this.host = "N/A";
            e.printStackTrace();
        }
        this.completionHandler = completionHandler;
        this.progressHandler = progressHandler;
    }

    private static ResponseInfo buildResponseInfo(int statusCode, Header[] headers, byte[] responseBody, String host, String ip, double duration, Throwable error) {
        String reqId = null;
        String xlog = null;
        String xvia = null;
        if (headers != null) {
            for (Header h : headers) {
                if ("X-Reqid".equals(h.getName())) {
                    reqId = h.getValue();
                    continue;
                }
                if ("X-Log".equals(h.getName())) {
                    xlog = h.getValue();
                    continue;
                }
                if ("X-Via".equals(h.getName())) {
                    xvia = h.getValue();
                    continue;
                }
                if ("X-Px".equals(h.getName())) {
                    xvia = h.getValue();
                    continue;
                }
                if (!"Fw-Via".equals(h.getName())) continue;
                xvia = h.getValue();
            }
        }
        String err = null;
        if (statusCode != 200) {
            if (responseBody != null) {
                try {
                    err = new String(responseBody, "utf-8");
                    JSONObject obj = new JSONObject(err);
                    err = obj.optString("error", err);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (error != null && (err = error.getMessage()) == null) {
                err = error.toString();
            }
        } else if (reqId == null) {
            err = "remote is not qiniu server!";
        }
        if (statusCode == 0) {
            statusCode = -1;
            String msg = error.getMessage();
            if (error instanceof IOException) {
                if (msg != null && msg.indexOf("UnknownHostException") == 0) {
                    statusCode = -1003;
                } else if (msg != null && msg.indexOf("Broken pipe") == 0) {
                    statusCode = -1005;
                } else if (error instanceof NoHttpResponseException) {
                    statusCode = -1005;
                } else if (error instanceof SocketTimeoutException) {
                    statusCode = -1001;
                } else if (error instanceof ConnectTimeoutException || error instanceof SocketException) {
                    statusCode = -1004;
                }
            }
        }
        return new ResponseInfo(statusCode, reqId, xlog, xvia, host, ip, duration, err);
    }

    private static JSONObject buildJsonResp(byte[] body) throws Exception {
        String str = new String(body, "utf-8");
        return new JSONObject(str);
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        double duration = (double)(System.currentTimeMillis() - this.reqStartTime) / 1000.0;
        JSONObject obj = null;
        Exception exception = null;
        try {
            obj = ResponseHandler.buildJsonResp(responseBody);
        }
        catch (Exception e) {
            exception = e;
        }
        ResponseInfo info = ResponseHandler.buildResponseInfo(statusCode, headers, null, this.host, this.ip, duration, exception);
        Log.i((String)"upload----success", (String)info.toString());
        this.completionHandler.complete(info, obj);
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        double duration = (double)(System.currentTimeMillis() - this.reqStartTime) / 1000.0;
        ResponseInfo info = ResponseHandler.buildResponseInfo(statusCode, headers, responseBody, this.host, this.ip, duration, error);
        Log.i((String)"upload----failed", (String)info.toString());
        this.completionHandler.complete(info, null);
    }

    public void onProgress(int bytesWritten, int totalSize) {
        if (this.progressHandler != null) {
            this.progressHandler.onProgress(bytesWritten, totalSize);
        }
    }

    public void onStart() {
        this.reqStartTime = System.currentTimeMillis();
        super.onStart();
    }

    protected void sendMessage(Message msg) {
        Throwable e;
        Object[] response;
        if (msg.what == 1 && (response = (Object[])msg.obj) != null && response.length >= 4 && !((e = (Throwable)response[3]) instanceof UnknownHostException)) {
            this.ip = Dns.getAddressesString(this.host);
        }
        super.sendMessage(msg);
    }
}

