/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.IReport;
import com.qiniu.android.http.ResponseInfo;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class StatReport
implements IReport {
    private ResponseInfo previousErrorInfo = null;
    private ResponseInfo previousSpeedInfo = null;

    @Override
    public synchronized Header[] appendStatHeaders(Header[] headers) {
        if (this.previousErrorInfo == null && this.previousSpeedInfo == null) {
            return headers;
        }
        int count = 1;
        if (this.previousErrorInfo != null && this.previousSpeedInfo != null) {
            count = 2;
        }
        Header[] h = new Header[headers.length + count];
        System.arraycopy(headers, 0, h, 0, headers.length);
        if (this.previousErrorInfo != null) {
            ResponseInfo einfo = this.previousErrorInfo;
            String reqId = einfo.reqId != null ? einfo.reqId : "";
            String cdnId = einfo.xvia != null ? einfo.xvia : "";
            h[headers.length] = new BasicHeader("X-Estat", String.format("e1;%d;%s;%s;%s;%f", einfo.statusCode, reqId, cdnId, einfo.ip, einfo.duration));
            this.previousErrorInfo = null;
        }
        if (this.previousSpeedInfo != null) {
            h[headers.length + count - 1] = new BasicHeader("X-Stat", String.format("v1;%s;%f;%s;%s", this.previousSpeedInfo.reqId, this.previousSpeedInfo.duration, this.previousSpeedInfo.xvia, this.previousSpeedInfo.ip));
        }
        return h;
    }

    @Override
    public synchronized void updateErrorInfo(ResponseInfo info) {
        this.previousErrorInfo = info;
    }

    @Override
    public synchronized void updateSpeedInfo(ResponseInfo info) {
        this.previousSpeedInfo = info;
    }
}

