/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public final class ByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;
    private final ProgressHandler progressHandler;
    private final CancellationHandler cancellationHandler;
    private static final int progressStep = 8192;

    public ByteArrayEntity(byte[] b, ProgressHandler h, CancellationHandler c) {
        this(b, 0, b.length, h, c);
    }

    public ByteArrayEntity(byte[] b, int off, int len, ProgressHandler h, CancellationHandler c) {
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        this.b = b;
        this.off = off;
        this.len = len;
        this.progressHandler = h;
        this.cancellationHandler = c;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.len;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (this.progressHandler != null || this.cancellationHandler != null) {
            this.writeWithNotify(outStream);
        } else {
            outStream.write(this.b, this.off, this.len);
        }
        outStream.flush();
    }

    private void writeWithNotify(OutputStream outStream) throws IOException {
        int len;
        for (int off = 0; off < this.len; off += len) {
            if (this.cancellationHandler != null && this.cancellationHandler.isCancelled()) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new CancellationHandler.CancellationException();
            }
            int left = this.len - off;
            len = left < 8192 ? left : 8192;
            outStream.write(this.b, this.off + off, len);
            if (this.progressHandler == null) continue;
            this.progressHandler.onProgress(off, this.len);
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

