/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.Config;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.HttpManager;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ResumeUploader
implements Runnable {
    private final int size;
    private final String key;
    private final UpCompletionHandler completionHandler;
    private final UploadOptions options;
    private final HttpManager httpManager;
    private final Recorder recorder;
    private final byte[] chunkBuffer;
    private final String[] contexts;
    private final Header[] headers;
    private final long modifyTime;
    private final String recorderKey;
    private RandomAccessFile file;
    private File f;
    private long crc32;

    ResumeUploader(HttpManager httpManager, Recorder recorder, File file, String key, String token, UpCompletionHandler completionHandler, UploadOptions options, String recorderKey) {
        this.httpManager = httpManager;
        this.recorder = recorder;
        this.f = file;
        this.recorderKey = recorderKey;
        this.size = (int)file.length();
        this.key = key;
        this.headers = new Header[1];
        this.headers[0] = new BasicHeader("Authorization", "UpToken " + token);
        this.completionHandler = completionHandler;
        this.options = options != null ? options : UploadOptions.defaultOptions();
        this.chunkBuffer = new byte[262144];
        long count = (this.size + 0x400000 - 1) / 0x400000;
        this.contexts = new String[(int)count];
        this.modifyTime = this.f.lastModified();
    }

    @Override
    public void run() {
        int offset = this.recoveryFromRecord();
        try {
            this.file = new RandomAccessFile(this.f, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.nextTask(offset, 0, Config.defaultUpHost);
    }

    private void makeBlock(String host, int offset, int blockSize, int chunkSize, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        String url = String.format(Locale.ENGLISH, "http://%s/mkblk/%d", host, blockSize);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        this.post(url, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void putChunk(String host, int offset, int chunkSize, String context, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        int chunkOffset = offset % 0x400000;
        String url = String.format(Locale.ENGLISH, "http://%s/bput/%s/%d", host, context, chunkOffset);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        this.post(url, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void makeFile(String host, CompletionHandler _completionHandler) {
        String mime = String.format(Locale.ENGLISH, "/mimeType/%s", UrlSafeBase64.encodeToString(this.options.mimeType));
        String keyStr = "";
        if (this.key != null) {
            keyStr = String.format("/key/%s", UrlSafeBase64.encodeToString(this.key));
        }
        String paramStr = "";
        if (this.options.params.size() != 0) {
            String[] str = new String[this.options.params.size()];
            int j = 0;
            for (Map.Entry<String, String> i : this.options.params.entrySet()) {
                str[j++] = String.format(Locale.ENGLISH, "%s/%s", i.getKey(), UrlSafeBase64.encodeToString(i.getValue()));
            }
            paramStr = "/" + StringUtils.join(str, "/");
        }
        String url = String.format(Locale.ENGLISH, "http://%s/mkfile/%d%s%s%s", host, this.size, mime, keyStr, paramStr);
        String bodyStr = StringUtils.join(this.contexts, ",");
        byte[] data = bodyStr.getBytes();
        this.post(url, data, 0, data.length, null, _completionHandler, null);
    }

    private void post(String url, byte[] data, int offset, int size, ProgressHandler progress, CompletionHandler completion, UpCancellationSignal c) {
        this.httpManager.postData(url, data, offset, size, this.headers, progress, completion, c);
    }

    private int calcPutSize(int offset) {
        int left = this.size - offset;
        return left < 262144 ? left : 262144;
    }

    private int calcBlockSize(int offset) {
        int left = this.size - offset;
        return left < 0x400000 ? left : 0x400000;
    }

    private boolean isCancelled() {
        return this.options.cancellationSignal.isCancelled();
    }

    private void nextTask(final int offset, final int retried, final String host) {
        if (offset == this.size) {
            CompletionHandler complete = new CompletionHandler(){

                @Override
                public void complete(ResponseInfo info, JSONObject response) {
                    if (info.isOK()) {
                        ResumeUploader.this.removeRecord();
                        ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, 1.0);
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                        return;
                    }
                    if (info.needRetry() && retried < 5) {
                        ResumeUploader.this.nextTask(offset, retried + 1, host);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                }
            };
            this.makeFile(host, complete);
            return;
        }
        final int chunkSize = this.calcPutSize(offset);
        ProgressHandler progress = new ProgressHandler(){

            @Override
            public void onProgress(int bytesWritten, int totalSize) {
                double percent = (double)(offset + bytesWritten) / (double)ResumeUploader.this.size;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, percent);
            }
        };
        CompletionHandler complete = new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (!info.isOK()) {
                    if (info.statusCode == 701) {
                        ResumeUploader.this.nextTask(offset / 0x400000 * 0x400000, retried, host);
                        return;
                    }
                    if (retried >= 5 || !info.needRetry()) {
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, null);
                        return;
                    }
                    String host2 = host;
                    if (info.needSwitchServer()) {
                        host2 = "up.qiniu.com";
                    }
                    ResumeUploader.this.nextTask(offset, retried + 1, host2);
                    return;
                }
                String context = null;
                if (response == null) {
                    ResumeUploader.this.nextTask(offset, retried + 1, host);
                    return;
                }
                long crc = 0L;
                try {
                    context = response.getString("ctx");
                    crc = response.getLong("crc32");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (context == null || crc != ResumeUploader.this.crc32) {
                    ResumeUploader.this.nextTask(offset, retried + 1, host);
                    return;
                }
                ((ResumeUploader)ResumeUploader.this).contexts[offset / 0x400000] = context;
                ResumeUploader.this.record(offset + chunkSize);
                ResumeUploader.this.nextTask(offset + chunkSize, retried, host);
            }
        };
        if (offset % 0x400000 == 0) {
            int blockSize = this.calcBlockSize(offset);
            this.makeBlock(host, offset, blockSize, chunkSize, progress, complete, this.options.cancellationSignal);
            return;
        }
        String context = this.contexts[offset / 0x400000];
        this.putChunk(host, offset, chunkSize, context, progress, complete, this.options.cancellationSignal);
    }

    private int recoveryFromRecord() {
        JSONObject obj;
        if (this.recorder == null) {
            return 0;
        }
        byte[] data = this.recorder.get(this.recorderKey);
        if (data == null) {
            return 0;
        }
        String jsonStr = new String(data);
        try {
            obj = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0;
        }
        int offset = obj.optInt("offset", 0);
        long modify = obj.optLong("modify_time", 0L);
        int fSize = obj.optInt("size", 0);
        JSONArray array = obj.optJSONArray("contexts");
        if (offset == 0 || modify != this.modifyTime || fSize != this.size || array == null || array.length() == 0) {
            return 0;
        }
        for (int i = 0; i < array.length(); ++i) {
            this.contexts[i] = array.optString(i);
        }
        return offset;
    }

    private void removeRecord() {
        if (this.recorder != null) {
            this.recorder.del(this.recorderKey);
        }
    }

    private void record(int offset) {
        if (this.recorder == null || offset == 0) {
            return;
        }
        String data = String.format(Locale.ENGLISH, "{\"size\":%d,\"offset\":%d, \"modify_time\":%d, \"contexts\":[%s]}", this.size, offset, this.modifyTime, StringUtils.jsonJoin(this.contexts));
        this.recorder.set(this.recorderKey, data.getBytes());
    }
}

