/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import com.qiniu.android.http.ByteArrayEntity;
import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.IReport;
import com.qiniu.android.http.MultipartBuilder;
import com.qiniu.android.http.PostArgs;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.Proxy;
import com.qiniu.android.http.ResponseHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.UpRedirectHandler;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.utils.Dns;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectHandler;
import org.apache.http.message.BasicHeader;
import org.json.JSONObject;

public final class HttpManager {
    private static final String userAgent = HttpManager.getUserAgent();
    private AsyncHttpClient client;
    private IReport reporter;
    private String backUpIp;
    private UrlConverter converter;

    public HttpManager(Proxy proxy) {
        this(proxy, null);
    }

    public HttpManager(Proxy proxy, IReport reporter) {
        this(proxy, reporter, null, 10, 30, null);
    }

    public HttpManager(Proxy proxy, IReport reporter, String backUpIp, int connectTimeout, int responseTimeout, UrlConverter converter) {
        this.backUpIp = backUpIp;
        this.client = new AsyncHttpClient();
        this.client.setConnectTimeout(connectTimeout * 1000);
        this.client.setResponseTimeout(responseTimeout * 1000);
        this.client.setUserAgent(userAgent);
        this.client.setEnableRedirects(true);
        this.client.setRedirectHandler((RedirectHandler)new UpRedirectHandler());
        AsyncHttpClient.blockRetryExceptionClass(CancellationHandler.CancellationException.class);
        if (proxy != null) {
            this.client.setProxy(proxy.hostAddress, proxy.port, proxy.user, proxy.password);
        }
        this.reporter = reporter;
        if (reporter == null) {
            this.reporter = new IReport(){

                @Override
                public Header[] appendStatHeaders(Header[] headers) {
                    return headers;
                }

                @Override
                public void updateErrorInfo(ResponseInfo info) {
                }

                @Override
                public void updateSpeedInfo(ResponseInfo info) {
                }
            };
        }
        this.converter = converter;
    }

    public HttpManager() {
        this(null);
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    private static String getUserAgent() {
        return String.format("QiniuAndroid/%s (%s; %s; %s)", "7.0.6", Build.VERSION.RELEASE, Build.MODEL, HttpManager.genId());
    }

    public void postData(String url, byte[] data, int offset, int size, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler c, boolean forceIp) {
        ByteArrayEntity entity = new ByteArrayEntity(data, offset, size, progressHandler, c);
        this.postEntity(url, (HttpEntity)entity, headers, progressHandler, completionHandler, forceIp);
    }

    public void postData(String url, byte[] data, Header[] headers, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler c, boolean forceIp) {
        this.postData(url, data, 0, data.length, headers, progressHandler, completionHandler, c, forceIp);
    }

    private void postEntity(String url, final HttpEntity entity, Header[] headers, final ProgressHandler progressHandler, final CompletionHandler completionHandler, final boolean forceIp) {
        CompletionHandler wrapper = this.wrap(completionHandler);
        final Header[] h = this.reporter.appendStatHeaders(headers);
        if (this.converter != null) {
            url = this.converter.convert(url);
        }
        ResponseHandler handler = new ResponseHandler(url, wrapper, progressHandler);
        if (this.backUpIp == null || this.converter != null) {
            this.client.post(null, url, h, entity, null, (ResponseHandlerInterface)handler);
            return;
        }
        final String url2 = url;
        ExecutorService t = this.client.getThreadPool();
        t.execute(new Runnable(){

            @Override
            public void run() {
                final URI uri = URI.create(url2);
                String ip = null;
                if (forceIp) {
                    ip = HttpManager.this.backUpIp;
                } else {
                    ip = Dns.getAddress(uri.getHost());
                    if (ip == null || ip.equals("")) {
                        ip = HttpManager.this.backUpIp;
                    }
                }
                final Header[] h2 = new Header[h.length + 1];
                System.arraycopy(h, 0, h2, 0, h.length);
                String newUrl = null;
                try {
                    newUrl = new URI(uri.getScheme(), null, ip, uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
                h2[h.length] = new BasicHeader("Host", uri.getHost());
                final String ip2 = ip;
                ResponseHandler handler2 = new ResponseHandler(url2, HttpManager.this.wrap(new CompletionHandler(){

                    @Override
                    public void complete(ResponseInfo info, JSONObject response) {
                        if (uri.getPort() == 80 || info.statusCode != -1004) {
                            completionHandler.complete(info, response);
                            return;
                        }
                        String newUrl80 = null;
                        try {
                            newUrl80 = new URI(uri.getScheme(), null, ip2, 80, uri.getPath(), uri.getQuery(), null).toString();
                        }
                        catch (URISyntaxException e) {
                            throw new AssertionError((Object)e);
                        }
                        ResponseHandler handler3 = new ResponseHandler(newUrl80, completionHandler, progressHandler);
                        HttpManager.this.client.post(null, newUrl80, h2, entity, null, (ResponseHandlerInterface)handler3);
                    }
                }), progressHandler);
                HttpManager.this.client.post(null, newUrl, h2, entity, null, (ResponseHandlerInterface)handler2);
            }
        });
    }

    public void multipartPost(String url, PostArgs args, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler c, boolean forceIp) {
        MultipartBuilder mbuilder = new MultipartBuilder();
        for (Map.Entry<String, String> entry : args.params.entrySet()) {
            mbuilder.addPart(entry.getKey(), entry.getValue());
        }
        if (args.data != null) {
            ByteArrayInputStream buff = new ByteArrayInputStream(args.data);
            try {
                mbuilder.addPart("file", args.fileName, buff, args.mimeType);
            }
            catch (IOException e) {
                completionHandler.complete(ResponseInfo.fileError(e), null);
                return;
            }
        }
        try {
            mbuilder.addPart("file", args.file, args.mimeType, "filename");
        }
        catch (IOException e) {
            completionHandler.complete(ResponseInfo.fileError(e), null);
            return;
        }
        ByteArrayEntity entity = mbuilder.build(progressHandler, c);
        Header[] h = this.reporter.appendStatHeaders(new Header[0]);
        this.postEntity(url, (HttpEntity)entity, h, progressHandler, completionHandler, forceIp);
    }

    private CompletionHandler wrap(final CompletionHandler completionHandler) {
        return new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                completionHandler.complete(info, response);
                if (info.isOK()) {
                    HttpManager.this.reporter.updateSpeedInfo(info);
                } else {
                    HttpManager.this.reporter.updateErrorInfo(info);
                }
            }
        };
    }
}

