/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.ByteArrayEntity;
import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

final class MultipartBuilder {
    private static final String STR_CR_LF = "\r\n";
    private static final byte[] CR_LF = new byte[]{13, 10};
    private static final byte[] TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary\r\n".getBytes();
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final String boundary;
    private final byte[] boundaryLine;
    private final byte[] boundaryEnd;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    public MultipartBuilder() {
        StringBuilder buf = new StringBuilder();
        Random rand = new Random();
        for (int i = 0; i < 30; ++i) {
            buf.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        this.boundary = buf.toString();
        this.boundaryLine = ("--" + this.boundary + STR_CR_LF).getBytes();
        this.boundaryEnd = ("--" + this.boundary + "--" + STR_CR_LF).getBytes();
    }

    private static StringBuilder appendQuotedString(StringBuilder target, String key) {
        target.append('\"');
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target.append("%0A");
                    continue block5;
                }
                case '\r': {
                    target.append("%0D");
                    continue block5;
                }
                case '\"': {
                    target.append("%22");
                    continue block5;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        target.append('\"');
        return target;
    }

    public void addPart(String key, String value, String contentType) {
        try {
            this.out.write(this.boundaryLine);
            this.out.write(this.createContentDisposition(key));
            this.out.write(this.createContentType(contentType));
            this.out.write(CR_LF);
            this.out.write(value.getBytes());
            this.out.write(CR_LF);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void addPartWithCharset(String key, String value, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        this.addPart(key, value, "text/plain; charset=" + charset);
    }

    public void addPart(String key, String value) {
        this.addPartWithCharset(key, value, null);
    }

    public void addPart(String key, File file) throws IOException {
        this.addPart(key, file, null, file.getName());
    }

    public void addPart(String key, File file, String type, String customFileName) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        IOException e = null;
        try {
            this.addPart(key, customFileName, fis, type);
        }
        catch (IOException e1) {
            e = e1;
        }
        fis.close();
        if (e != null) {
            throw e;
        }
    }

    public void addPart(String key, String streamName, InputStream inputStream, String type) throws IOException {
        int l;
        this.out.write(this.boundaryLine);
        this.out.write(this.createContentDisposition(key, streamName));
        this.out.write(this.createContentType(type));
        this.out.write(TRANSFER_ENCODING_BINARY);
        this.out.write(CR_LF);
        byte[] tmp = new byte[8192];
        while ((l = inputStream.read(tmp)) != -1) {
            this.out.write(tmp, 0, l);
        }
        this.out.write(CR_LF);
    }

    private String normalizeContentType(String type) {
        return type == null ? "application/octet-stream" : type;
    }

    private byte[] createContentType(String type) {
        String result = "Content-Type: " + this.normalizeContentType(type) + STR_CR_LF;
        return result.getBytes();
    }

    private byte[] createContentDisposition(String key) {
        StringBuilder builder = new StringBuilder("Content-Disposition: form-data; name=");
        MultipartBuilder.appendQuotedString(builder, key);
        builder.append(STR_CR_LF);
        return StringUtils.utf8Bytes(builder.toString());
    }

    private byte[] createContentDisposition(String key, String fileName) {
        StringBuilder builder = new StringBuilder("Content-Disposition: form-data; name=");
        MultipartBuilder.appendQuotedString(builder, key);
        builder.append("; filename=");
        MultipartBuilder.appendQuotedString(builder, fileName);
        builder.append(STR_CR_LF);
        return StringUtils.utf8Bytes(builder.toString());
    }

    public ByteArrayEntity build(ProgressHandler progressHandler, CancellationHandler c) {
        try {
            this.out.write(this.boundaryEnd);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        byte[] data = this.out.toByteArray();
        ByteArrayEntity b = new ByteArrayEntity(data, progressHandler, c);
        b.setContentType((Header)new BasicHeader("Content-Type", "multipart/form-data; boundary=" + this.boundary));
        return b;
    }
}

