/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.Proxy;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.Zone;
import java.io.File;

public final class Configuration {
    public static final int BLOCK_SIZE = 0x400000;
    public final String upHost;
    public final String upHostBackup;
    public final String upIp;
    public final int upPort;
    public final Recorder recorder;
    public final KeyGenerator keyGen;
    public final Proxy proxy;
    public final int chunkSize;
    public final int putThreshold;
    public final int connectTimeout;
    public final int responseTimeout;
    public final int retryMax;
    public UrlConverter urlConverter;

    private Configuration(Builder builder) {
        this.upHost = builder.upHost;
        this.upHostBackup = builder.upHostBackup;
        this.upIp = Configuration.getIp(builder);
        this.upPort = Configuration.getPort(builder);
        this.chunkSize = builder.chunkSize;
        this.putThreshold = builder.putThreshold;
        this.connectTimeout = builder.connectTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.recorder = builder.recorder;
        this.keyGen = this.getKeyGen(builder.keyGen);
        this.retryMax = builder.retryMax;
        this.proxy = builder.proxy;
        this.urlConverter = builder.urlConverter;
    }

    private static int getPort(Builder builder) {
        if (builder.urlConverter != null) {
            return 80;
        }
        return builder.upPort;
    }

    private static String getIp(Builder builder) {
        if (builder.urlConverter != null) {
            return null;
        }
        return builder.upIp;
    }

    private KeyGenerator getKeyGen(KeyGenerator keyGen) {
        if (keyGen == null) {
            keyGen = new KeyGenerator(){

                @Override
                public String gen(String key, File file) {
                    return key + "_._" + new StringBuffer(file.getAbsolutePath()).reverse();
                }
            };
        }
        return keyGen;
    }

    public static class Builder {
        private String upHost;
        private String upHostBackup;
        private String upIp;
        private int upPort;
        private Recorder recorder = null;
        private KeyGenerator keyGen = null;
        private Proxy proxy = null;
        private int chunkSize = 262144;
        private int putThreshold = 524288;
        private int connectTimeout = 10;
        private int responseTimeout = 60;
        private int retryMax = 5;
        private UrlConverter urlConverter = null;

        public Builder() {
            this.upHost = Zone.zone0.upHost;
            this.upHostBackup = Zone.zone0.upHostBackup;
            this.upIp = Zone.zone0.upIp;
            this.upPort = 8888;
        }

        public Builder zone(Zone zone) {
            this.upHost = zone.upHost;
            this.upHostBackup = zone.upHostBackup;
            this.upIp = zone.upIp;
            return this;
        }

        public Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder recorder(Recorder recorder, KeyGenerator keyGen) {
            this.recorder = recorder;
            this.keyGen = keyGen;
            return this;
        }

        public Builder upPort(int port) {
            this.upPort = port;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder chunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder putThreshhold(int size) {
            this.putThreshold = size;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder responseTimeout(int timeout) {
            this.responseTimeout = timeout;
            return this;
        }

        public Builder retryMax(int times) {
            this.retryMax = times;
            return this;
        }

        public Builder urlConverter(UrlConverter converter) {
            this.urlConverter = converter;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

