/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.HttpManager;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.StatReport;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUploader;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.ResumeUploader;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import java.io.File;

public final class UploadManager {
    private final Configuration config;
    private final HttpManager httpManager;

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration config) {
        this.config = config;
        this.httpManager = new HttpManager(config.proxy, new StatReport(), config.upIp, config.connectTimeout, config.responseTimeout, config.urlConverter);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    private static boolean areInvalidArg(final String key, byte[] data, File f, String token, final UpCompletionHandler completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("no UpCompletionHandler");
        }
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            final ResponseInfo info = ResponseInfo.invalidArgument(message);
            AsyncRun.run(new Runnable(){

                @Override
                public void run() {
                    completionHandler.complete(key, info, null);
                }
            });
            return true;
        }
        return false;
    }

    public void put(final byte[] data, final String key, String token, final UpCompletionHandler completionHandler, final UploadOptions options) {
        if (UploadManager.areInvalidArg(key, data, null, token, completionHandler)) {
            return;
        }
        final UpToken decodedToken = UpToken.parse(token);
        if (decodedToken == null) {
            final ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            AsyncRun.run(new Runnable(){

                @Override
                public void run() {
                    completionHandler.complete(key, info, null);
                }
            });
            return;
        }
        AsyncRun.run(new Runnable(){

            @Override
            public void run() {
                FormUploader.upload(UploadManager.this.httpManager, UploadManager.this.config, data, key, decodedToken, completionHandler, options);
            }
        });
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(File file, final String key, String token, final UpCompletionHandler completionHandler, UploadOptions options) {
        if (UploadManager.areInvalidArg(key, null, file, token, completionHandler)) {
            return;
        }
        UpToken decodedToken = UpToken.parse(token);
        if (decodedToken == null) {
            final ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            AsyncRun.run(new Runnable(){

                @Override
                public void run() {
                    completionHandler.complete(key, info, null);
                }
            });
            return;
        }
        long size = file.length();
        if (size <= (long)this.config.putThreshold) {
            FormUploader.upload(this.httpManager, this.config, file, key, decodedToken, completionHandler, options);
            return;
        }
        String recorderKey = this.config.keyGen.gen(key, file);
        ResumeUploader uploader = new ResumeUploader(this.httpManager, this.config, file, key, decodedToken, completionHandler, options, recorderKey);
        AsyncRun.run(uploader);
    }
}

