/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.util.Log;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpProgressHandler;
import java.util.HashMap;
import java.util.Map;

public final class UploadOptions {
    final Map<String, String> params;
    final String mimeType;
    final boolean checkCrc;
    final UpProgressHandler progressHandler;
    final UpCancellationSignal cancellationSignal;

    public UploadOptions(Map<String, String> params, String mimeType, boolean checkCrc, UpProgressHandler progressHandler, UpCancellationSignal cancellationSignal) {
        this.params = UploadOptions.filterParam(params);
        this.mimeType = UploadOptions.mime(mimeType);
        this.checkCrc = checkCrc;
        this.progressHandler = progressHandler != null ? progressHandler : new UpProgressHandler(){

            @Override
            public void progress(String key, double percent) {
                Log.d((String)"qiniu up progress", (String)("" + percent));
            }
        };
        this.cancellationSignal = cancellationSignal != null ? cancellationSignal : new UpCancellationSignal(){

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }

    private static Map<String, String> filterParam(Map<String, String> params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (params == null) {
            return ret;
        }
        for (Map.Entry<String, String> i : params.entrySet()) {
            if (!i.getKey().startsWith("x:") || i.getValue() == null || i.getValue().equals("")) continue;
            ret.put(i.getKey(), i.getValue());
        }
        return ret;
    }

    static UploadOptions defaultOptions() {
        return new UploadOptions(null, null, false, null, null);
    }

    private static String mime(String mimeType) {
        if (mimeType == null || mimeType.equals("")) {
            return "application/octet-stream";
        }
        return mimeType;
    }
}

