/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.http.AsyncHttpClientMod;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.conn.DefaultClientConnection;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public final class ClientConnectionOperator
implements org.apache.http.conn.ClientConnectionOperator {
    protected final SchemeRegistry schemeRegistry;
    protected final DnsManager dnsResolver;

    public ClientConnectionOperator(SchemeRegistry schemes, DnsManager dnsResolver) {
        if (schemes == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schemes;
        this.dnsResolver = dnsResolver;
    }

    public static boolean validIP(String ip) {
        if (ip == null || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        if (ip.contains("-")) {
            return false;
        }
        try {
            int x = 0;
            int y = ip.indexOf(46);
            if (y != -1 && Integer.parseInt(ip.substring(x, y)) > 255) {
                return false;
            }
            if ((x = ip.indexOf(46, ++y)) != -1 && Integer.parseInt(ip.substring(y, x)) > 255) {
                return false;
            }
            return (y = ip.indexOf(46, ++x)) == -1 || Integer.parseInt(ip.substring(x, y)) <= 255 || Integer.parseInt(ip.substring(++y, ip.length() - 1)) <= 255 || ip.charAt(ip.length() - 1) == '.';
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public OperatedClientConnection createConnection() {
        return new DefaultClientConnection();
    }

    public void openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
        String[] ips;
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (conn.isOpen()) {
            throw new IllegalArgumentException("Connection must not be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        SocketFactory sf = schm.getSocketFactory();
        String host = target.getHostName();
        if (ClientConnectionOperator.validIP(host)) {
            ips = new String[]{host};
        } else {
            ips = this.systemResolv(host);
            if (ips == null || ips.length == 0) {
                throw new UnknownHostException("no ip for " + host);
            }
        }
        int port = schm.resolvePort(target.getPort());
        for (int i = 0; i < ips.length; ++i) {
            String ip = ips[i];
            boolean last = i == ips.length - 1;
            Socket sock = sf.createSocket();
            conn.opening(sock, target);
            try {
                Socket connsock = sf.connectSocket(sock, ip, port, local, 0, params);
                if (sock != connsock) {
                    sock = connsock;
                    conn.opening(sock, target);
                }
                this.prepareSocket(sock, context, params);
                conn.openCompleted(sf.isSecure(sock), params);
                AsyncHttpClientMod.ip.set(ip);
                return;
            }
            catch (ConnectException ex) {
                if (!last) continue;
                throw new HttpHostConnectException(target, ex);
            }
        }
    }

    public void updateSecureConnection(OperatedClientConnection conn, HttpHost target, HttpContext context, HttpParams params) throws IOException {
        Socket sock;
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (!conn.isOpen()) {
            throw new IllegalArgumentException("Connection must be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        if (!(schm.getSocketFactory() instanceof LayeredSocketFactory)) {
            throw new IllegalArgumentException("Target scheme (" + schm.getName() + ") must have layered socket factory.");
        }
        LayeredSocketFactory lsf = (LayeredSocketFactory)schm.getSocketFactory();
        try {
            sock = lsf.createSocket(conn.getSocket(), target.getHostName(), target.getPort(), true);
        }
        catch (ConnectException ex) {
            throw new HttpHostConnectException(target, ex);
        }
        this.prepareSocket(sock, context, params);
        conn.update(sock, target, lsf.isSecure(sock), params);
    }

    protected void prepareSocket(Socket sock, HttpContext context, HttpParams params) throws IOException {
        sock.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)params));
        sock.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)params));
        int linger = HttpConnectionParams.getLinger((HttpParams)params);
        if (linger >= 0) {
            sock.setSoLinger(linger > 0, linger);
        }
    }

    private String[] systemResolv(String domain) throws UnknownHostException {
        if (this.dnsResolver == null) {
            InetAddress[] addresses = InetAddress.getAllByName(domain);
            String[] x = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                x[i] = addresses[i].getHostAddress();
            }
            return x;
        }
        try {
            return this.dnsResolver.query(new Domain(domain, true, false, 3600));
        }
        catch (IOException e) {
            throw new UnknownHostException(e.getMessage());
        }
    }
}

