/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import android.text.TextUtils;
import java.util.Random;

public final class UserAgent {
    private static UserAgent _instance = new UserAgent();
    public final String id = UserAgent.genId();
    public final String ua = UserAgent.getUserAgent(this.id);

    private UserAgent() {
    }

    public static UserAgent instance() {
        return _instance;
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    private static String getUserAgent(String id) {
        return String.format("QiniuAndroid/%s (%s; %s; %s)", "7.0.7.2", Build.VERSION.RELEASE, UserAgent.device(), id);
    }

    private static String device() {
        String model = Build.MODEL.trim();
        String device = UserAgent.deviceName(Build.MANUFACTURER.trim(), model);
        if (TextUtils.isEmpty((CharSequence)device)) {
            device = UserAgent.deviceName(Build.BRAND.trim(), model);
        }
        return (device == null ? "" : device) + "-" + model;
    }

    private static String deviceName(String manufacturer, String model) {
        String str = manufacturer.toLowerCase();
        if (str.startsWith("unknown") || str.startsWith("alps") || str.startsWith("android") || str.startsWith("sprd") || str.startsWith("spreadtrum") || str.startsWith("rockchip") || str.startsWith("wondermedia") || str.startsWith("mtk") || str.startsWith("mt65") || str.startsWith("nvidia") || str.startsWith("brcm") || str.startsWith("marvell") || model.toLowerCase().contains(str)) {
            return null;
        }
        return manufacturer;
    }

    public String toString() {
        return this.ua;
    }
}

