/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.UserAgent;
import java.util.Locale;

public final class ResponseInfo {
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final double duration;
    public final String host;
    public final String ip;
    public final int port;
    public final String path;
    public final String id;
    public final long timeStamp;
    public final long sent;

    public ResponseInfo(int statusCode, String reqId, String xlog, String xvia, String host, String path, String ip, int port, double duration, long sent, String error) {
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.host = host;
        this.path = path;
        this.duration = duration;
        this.error = error;
        this.ip = ip;
        this.port = port;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        this.sent = sent;
    }

    public static ResponseInfo zeroSize() {
        return new ResponseInfo(-6, "", "", "", "", "", "", -1, 0.0, 0L, "file or data size is zero");
    }

    public static ResponseInfo cancelled() {
        return new ResponseInfo(-2, "", "", "", "", "", "", -1, 0.0, 0L, "cancelled by user");
    }

    public static ResponseInfo invalidArgument(String message) {
        return new ResponseInfo(-4, "", "", "", "", "", "", -1, 0.0, 0L, message);
    }

    public static ResponseInfo invalidToken(String message) {
        return new ResponseInfo(-5, "", "", "", "", "", "", -1, 0.0, 0L, message);
    }

    public static ResponseInfo fileError(Exception e) {
        return new ResponseInfo(-3, "", "", "", "", "", "", -1, 0.0, 0L, e.getMessage());
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && this.reqId != null;
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1003 || this.statusCode == -1004 || this.statusCode == -1001 || this.statusCode == -1005;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null);
    }

    public boolean isNotQiniu() {
        return this.statusCode < 500 && this.statusCode >= 200 && this.reqId == null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ver:%s,ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, host:%s, path:%s, ip:%s, port:%d, duration:%f s, time:%d, sent:%d,error:%s}", "7.1.1", this.id, this.statusCode, this.reqId, this.xlog, this.xvia, this.host, this.path, this.ip, this.port, this.duration, this.timeStamp, this.sent, this.error);
    }
}

