/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.StringMap;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ResumeUploader
implements Runnable {
    private final int size;
    private final String key;
    private final UpCompletionHandler completionHandler;
    private final UploadOptions options;
    private final Client client;
    private final Configuration config;
    private final byte[] chunkBuffer;
    private final String[] contexts;
    private final StringMap headers;
    private final long modifyTime;
    private final String recorderKey;
    private RandomAccessFile file;
    private File f;
    private long crc32;
    private UpToken token;

    ResumeUploader(Client client, Configuration config, File f, String key, UpToken token, final UpCompletionHandler completionHandler, UploadOptions options, String recorderKey) {
        this.client = client;
        this.config = config;
        this.f = f;
        this.recorderKey = recorderKey;
        this.size = (int)f.length();
        this.key = key;
        this.headers = new StringMap().put("Authorization", "UpToken " + token.token);
        this.file = null;
        this.completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (ResumeUploader.this.file != null) {
                    try {
                        ResumeUploader.this.file.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                completionHandler.complete(key, info, response);
            }
        };
        this.options = options != null ? options : UploadOptions.defaultOptions();
        this.chunkBuffer = new byte[config.chunkSize];
        long count = (this.size + 0x400000 - 1) / 0x400000;
        this.contexts = new String[(int)count];
        this.modifyTime = f.lastModified();
        this.token = token;
    }

    @Override
    public void run() {
        int offset = this.recoveryFromRecord();
        try {
            this.file = new RandomAccessFile(this.f, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.nextTask(offset, 0, this.config.up.address);
    }

    private void makeBlock(URI address, int offset, int blockSize, int chunkSize, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        String path = String.format(Locale.ENGLISH, "/mkblk/%d", blockSize);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        URI u = this.newURI(address, path);
        this.post(u, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void putChunk(URI address, int offset, int chunkSize, String context, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        int chunkOffset = offset % 0x400000;
        String path = String.format(Locale.ENGLISH, "/bput/%s/%d", context, chunkOffset);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        URI u = this.newURI(address, path);
        this.post(u, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void makeFile(URI uri, CompletionHandler _completionHandler, UpCancellationSignal c) {
        String mime = String.format(Locale.ENGLISH, "/mimeType/%s/fname/%s", UrlSafeBase64.encodeToString(this.options.mimeType), UrlSafeBase64.encodeToString(this.f.getName()));
        String keyStr = "";
        if (this.key != null) {
            keyStr = String.format("/key/%s", UrlSafeBase64.encodeToString(this.key));
        }
        String paramStr = "";
        if (this.options.params.size() != 0) {
            String[] str = new String[this.options.params.size()];
            int j = 0;
            for (Map.Entry<String, String> i : this.options.params.entrySet()) {
                str[j++] = String.format(Locale.ENGLISH, "%s/%s", i.getKey(), UrlSafeBase64.encodeToString(i.getValue()));
            }
            paramStr = "/" + StringUtils.join(str, "/");
        }
        String path = String.format(Locale.ENGLISH, "/mkfile/%d%s%s%s", this.size, mime, keyStr, paramStr);
        URI address = uri;
        try {
            address = new URI(uri.getScheme(), uri.getHost(), path, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String bodyStr = StringUtils.join(this.contexts, ",");
        byte[] data = bodyStr.getBytes();
        this.post(address, data, 0, data.length, null, _completionHandler, c);
    }

    private void post(URI uri, byte[] data, int offset, int size, ProgressHandler progress, CompletionHandler completion, UpCancellationSignal c) {
        this.client.asyncPost(uri.toString(), data, offset, size, this.headers, progress, completion, c);
    }

    private int calcPutSize(int offset) {
        int left = this.size - offset;
        return left < this.config.chunkSize ? left : this.config.chunkSize;
    }

    private int calcBlockSize(int offset) {
        int left = this.size - offset;
        return left < 0x400000 ? left : 0x400000;
    }

    private boolean isCancelled() {
        return this.options.cancellationSignal.isCancelled();
    }

    private void nextTask(final int offset, final int retried, final URI address) {
        if (this.isCancelled()) {
            ResponseInfo i = ResponseInfo.cancelled();
            this.completionHandler.complete(this.key, i, null);
            return;
        }
        if (offset == this.size) {
            CompletionHandler complete = new CompletionHandler(){

                @Override
                public void complete(ResponseInfo info, JSONObject response) {
                    if (info.isOK()) {
                        ResumeUploader.this.removeRecord();
                        ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, 1.0);
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                        return;
                    }
                    if ((ResumeUploader.this.isNotQiniu(info) || info.needRetry()) && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(offset, retried + 1, ((ResumeUploader)ResumeUploader.this).config.upBackup.address);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                }
            };
            this.makeFile(address, complete, this.options.cancellationSignal);
            return;
        }
        final int chunkSize = this.calcPutSize(offset);
        ProgressHandler progress = new ProgressHandler(){

            @Override
            public void onProgress(int bytesWritten, int totalSize) {
                double percent = (double)(offset + bytesWritten) / (double)ResumeUploader.this.size;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, percent);
            }
        };
        CompletionHandler complete = new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (!info.isOK()) {
                    if (info.statusCode == 701 && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(offset / 0x400000 * 0x400000, retried + 1, address);
                        return;
                    }
                    if ((ResumeUploader.this.isNotQiniu(info) || info.needRetry()) && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(offset, retried + 1, ((ResumeUploader)ResumeUploader.this).config.upBackup.address);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                    return;
                }
                String context = null;
                if (response == null && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    ResumeUploader.this.nextTask(offset, retried + 1, ((ResumeUploader)ResumeUploader.this).config.upBackup.address);
                    return;
                }
                long crc = 0L;
                try {
                    context = response.getString("ctx");
                    crc = response.getLong("crc32");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if ((context == null || crc != ResumeUploader.this.crc32) && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    ResumeUploader.this.nextTask(offset, retried + 1, ((ResumeUploader)ResumeUploader.this).config.upBackup.address);
                    return;
                }
                ((ResumeUploader)ResumeUploader.this).contexts[offset / 0x400000] = context;
                ResumeUploader.this.record(offset + chunkSize);
                ResumeUploader.this.nextTask(offset + chunkSize, retried, address);
            }
        };
        if (offset % 0x400000 == 0) {
            int blockSize = this.calcBlockSize(offset);
            this.makeBlock(address, offset, blockSize, chunkSize, progress, complete, this.options.cancellationSignal);
            return;
        }
        String context = this.contexts[offset / 0x400000];
        this.putChunk(address, offset, chunkSize, context, progress, complete, this.options.cancellationSignal);
    }

    private int recoveryFromRecord() {
        JSONObject obj;
        if (this.config.recorder == null) {
            return 0;
        }
        byte[] data = this.config.recorder.get(this.recorderKey);
        if (data == null) {
            return 0;
        }
        String jsonStr = new String(data);
        try {
            obj = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0;
        }
        int offset = obj.optInt("offset", 0);
        long modify = obj.optLong("modify_time", 0L);
        int fSize = obj.optInt("size", 0);
        JSONArray array = obj.optJSONArray("contexts");
        if (offset == 0 || modify != this.modifyTime || fSize != this.size || array == null || array.length() == 0) {
            return 0;
        }
        for (int i = 0; i < array.length(); ++i) {
            this.contexts[i] = array.optString(i);
        }
        return offset;
    }

    private void removeRecord() {
        if (this.config.recorder != null) {
            this.config.recorder.del(this.recorderKey);
        }
    }

    private void record(int offset) {
        if (this.config.recorder == null || offset == 0) {
            return;
        }
        String data = String.format(Locale.ENGLISH, "{\"size\":%d,\"offset\":%d, \"modify_time\":%d, \"contexts\":[%s]}", this.size, offset, this.modifyTime, StringUtils.jsonJoin(this.contexts));
        this.config.recorder.set(this.recorderKey, data.getBytes());
    }

    private boolean isNotQiniu(ResponseInfo info) {
        return info.isNotQiniu() && !this.token.hasReturnUrl();
    }

    private URI newURI(URI uri, String path) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return uri;
        }
    }
}

