/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import android.text.TextUtils;
import com.qiniu.android.utils.StringUtils;
import java.util.Locale;
import java.util.Random;

public final class UserAgent {
    private static UserAgent _instance = new UserAgent();
    public final String id = UserAgent.genId();
    public final String ua = UserAgent.getUserAgent(this.id);

    private UserAgent() {
    }

    public static UserAgent instance() {
        return _instance;
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    private static String getUserAgent(String id) {
        return String.format("QiniuAndroid/%s (%s; %s; %s)", "7.2.1", UserAgent.osVersion(), UserAgent.device(), id);
    }

    private static String osVersion() {
        String v = Build.VERSION.RELEASE;
        if (v == null) {
            return "";
        }
        return StringUtils.strip(v.trim());
    }

    private static String device() {
        String model = Build.MODEL.trim();
        String device = UserAgent.deviceName(Build.MANUFACTURER.trim(), model);
        if (TextUtils.isEmpty((CharSequence)device)) {
            device = UserAgent.deviceName(Build.BRAND.trim(), model);
        }
        return StringUtils.strip((device == null ? "" : device) + "-" + model);
    }

    private static String deviceName(String manufacturer, String model) {
        String str = manufacturer.toLowerCase(Locale.getDefault());
        if (str.startsWith("unknown") || str.startsWith("alps") || str.startsWith("android") || str.startsWith("sprd") || str.startsWith("spreadtrum") || str.startsWith("rockchip") || str.startsWith("wondermedia") || str.startsWith("mtk") || str.startsWith("mt65") || str.startsWith("nvidia") || str.startsWith("brcm") || str.startsWith("marvell") || model.toLowerCase(Locale.getDefault()).contains(str)) {
            return null;
        }
        return manufacturer;
    }

    public String toString() {
        return this.ua;
    }
}

