/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.collect;

import com.qiniu.android.collect.Config;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.storage.UpToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class UploadInfoCollector {
    private static ExecutorService singleServer = null;
    private static OkHttpClient httpClient = null;
    private static UploadInfoCollector httpCollector;
    private final String serverURL;
    private final String recordFileName;
    private File recordFile = null;
    private long lastUpload;

    private UploadInfoCollector(String recordFileName, String serverURL) {
        this.recordFileName = recordFileName;
        this.serverURL = serverURL;
        try {
            this.reset0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static UploadInfoCollector getHttpCollector() {
        if (httpCollector == null) {
            httpCollector = new UploadInfoCollector("_qiniu_record_file_hs5z9lo7anx03", "https://uplog.qbox.me/log/3");
        }
        return httpCollector;
    }

    public static void clean() {
        try {
            if (singleServer != null) {
                singleServer.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        singleServer = null;
        httpClient = null;
        try {
            UploadInfoCollector.getHttpCollector().clean0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        httpCollector = null;
    }

    public static void reset() {
        try {
            UploadInfoCollector.getHttpCollector().reset0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void handleHttp(UpToken upToken, RecordMsg record) {
        try {
            if (Config.isRecord) {
                UploadInfoCollector.getHttpCollector().handle0(upToken, record);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void handleUpload(UpToken upToken, RecordMsg record) {
        UploadInfoCollector.handleHttp(upToken, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String msg, boolean isAppend) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, isAppend);
            fos.write(msg.getBytes(Charset.forName("UTF-8")));
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static OkHttpClient getHttpClient() {
        if (httpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(10L, TimeUnit.SECONDS);
            builder.readTimeout(15L, TimeUnit.SECONDS);
            builder.writeTimeout((long)((Config.interval / 2 + 1) * 60 - 10), TimeUnit.SECONDS);
            httpClient = builder.build();
        }
        return httpClient;
    }

    private void clean0() {
        try {
            if (this.recordFile != null) {
                this.recordFile.delete();
            } else {
                new File(this.getRecordDir(Config.recordDir), this.recordFileName).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recordFile = null;
    }

    private void reset0() throws IOException {
        if (Config.isRecord) {
            this.initRecordFile(this.getRecordDir(Config.recordDir));
        }
        if (!Config.isRecord && singleServer != null) {
            singleServer.shutdown();
        }
        if (Config.isRecord && (singleServer == null || singleServer.isShutdown())) {
            singleServer = Executors.newSingleThreadExecutor();
        }
    }

    private File getRecordDir(String recordDir) {
        return new File(recordDir);
    }

    private void initRecordFile(File recordDir) throws IOException {
        if (recordDir == null) {
            throw new IOException("record's dir is not setted");
        }
        if (!recordDir.exists()) {
            boolean r = recordDir.mkdirs();
            if (!r) {
                throw new IOException("mkdir failed: " + recordDir.getAbsolutePath());
            }
            return;
        }
        if (!recordDir.isDirectory()) {
            throw new IOException(recordDir.getAbsolutePath() + " is not a dir");
        }
        this.recordFile = new File(recordDir, this.recordFileName);
    }

    private void handle0(final UpToken upToken, final RecordMsg record) {
        if (singleServer != null && !singleServer.isShutdown()) {
            Runnable taskRecord = new Runnable(){

                @Override
                public void run() {
                    if (Config.isRecord) {
                        try {
                            UploadInfoCollector.this.tryRecode(record.toRecordMsg(), UploadInfoCollector.this.recordFile);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            };
            singleServer.submit(taskRecord);
            if (Config.isUpload && upToken != UpToken.NULL) {
                Runnable taskUpload = new Runnable(){

                    @Override
                    public void run() {
                        if (Config.isRecord && Config.isUpload) {
                            try {
                                UploadInfoCollector.this.tryUploadAndClean(upToken, UploadInfoCollector.this.recordFile);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                singleServer.submit(taskUpload);
            }
        }
    }

    private void tryRecode(String msg, File recordFile) {
        if (Config.isRecord && recordFile.length() < (long)Config.maxRecordFileSize) {
            UploadInfoCollector.writeToFile(recordFile, msg + "\n", true);
        }
    }

    private void tryUploadAndClean(UpToken upToken, File recordFile) {
        long now;
        if (Config.isUpload && recordFile.length() > (long)Config.uploadThreshold && (now = new Date().getTime()) > this.lastUpload + (long)(Config.interval * 60 * 1000)) {
            this.lastUpload = now;
            boolean success = this.upload(upToken, recordFile);
            if (success) {
                UploadInfoCollector.writeToFile(recordFile, "", false);
                UploadInfoCollector.writeToFile(recordFile, "", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upload(UpToken upToken, File recordFile) {
        boolean bl;
        OkHttpClient client = UploadInfoCollector.getHttpClient();
        RequestBody reqBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (File)recordFile);
        Request request = new Request.Builder().url(this.serverURL).addHeader("Authorization", "UpToken " + upToken.token).addHeader("User-Agent", UserAgent.instance().getUa(upToken.accessKey)).post(reqBody).build();
        Response res = client.newCall(request).execute();
        try {
            bl = this.isOk(res);
        }
        catch (Throwable throwable) {
            try {
                try {
                    res.body().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            res.body().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean isOk(Response res) {
        return res.isSuccessful() && res.header("X-Reqid") != null;
    }

    public static abstract class RecordMsg {
        public abstract String toRecordMsg();
    }
}

