/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.utils.AsyncRun;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class CountingRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private final RequestBody body;
    private final ProgressHandler progress;
    private final long totalSize;
    private final CancellationHandler cancellationHandler;

    public CountingRequestBody(RequestBody body, ProgressHandler progress, long totalSize, CancellationHandler cancellationHandler) {
        this.body = body;
        this.progress = progress;
        this.totalSize = totalSize;
        this.cancellationHandler = cancellationHandler;
    }

    public long contentLength() throws IOException {
        return this.body.contentLength();
    }

    public MediaType contentType() {
        return this.body.contentType();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.body.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    protected final class CountingSink
    extends ForwardingSink {
        private int bytesWritten;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            if (CountingRequestBody.this.cancellationHandler == null && CountingRequestBody.this.progress == null) {
                super.write(source, byteCount);
                return;
            }
            if (CountingRequestBody.this.cancellationHandler != null && CountingRequestBody.this.cancellationHandler.isCancelled()) {
                throw new CancellationHandler.CancellationException();
            }
            super.write(source, byteCount);
            this.bytesWritten = (int)((long)this.bytesWritten + byteCount);
            if (CountingRequestBody.this.progress != null) {
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        CountingRequestBody.this.progress.onProgress(CountingSink.this.bytesWritten, CountingRequestBody.this.totalSize);
                    }
                });
            }
        }
    }
}

