/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.util.Log;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.PostArgs;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.StringMap;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

final class FormUploader {
    FormUploader() {
    }

    static void upload(Client httpManager, Configuration config, byte[] data, String key, UpToken token, UpCompletionHandler completionHandler, UploadOptions options) {
        FormUploader.post(data, null, key, token, completionHandler, options, httpManager, config);
    }

    static void upload(Client client, Configuration config, File file, String key, UpToken token, UpCompletionHandler completionHandler, UploadOptions options) {
        FormUploader.post(null, file, key, token, completionHandler, options, client, config);
    }

    private static void post(byte[] data, File file, String k, final UpToken token, final UpCompletionHandler completionHandler, UploadOptions optionsIn, final Client client, final Configuration config) {
        final String key = k;
        StringMap params = new StringMap();
        final PostArgs args = new PostArgs();
        if (k != null) {
            params.put("key", key);
            args.fileName = key;
        } else {
            args.fileName = "?";
        }
        if (file != null) {
            args.fileName = file.getName();
        }
        params.put("token", token.token);
        final UploadOptions options = optionsIn != null ? optionsIn : UploadOptions.defaultOptions();
        params.putFileds(options.params);
        long crc = 0L;
        if (file != null) {
            try {
                crc = Crc32.file(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            crc = Crc32.bytes(data);
        }
        params.put("crc32", "" + crc);
        final ProgressHandler progress = new ProgressHandler(){

            @Override
            public void onProgress(long bytesWritten, long totalSize) {
                double percent = (double)bytesWritten / (double)totalSize;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                options.progressHandler.progress(key, percent);
            }
        };
        args.data = data;
        args.file = file;
        args.mimeType = options.mimeType;
        args.params = params;
        final String upHost = config.zone.upHost(token.token, config.useHttps, null);
        Log.d((String)"Qiniu.FormUploader", (String)("upload use up host " + upHost));
        CompletionHandler completion = new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        completionHandler.complete(key, info, response);
                        return;
                    }
                }
                if (info.isOK()) {
                    options.progressHandler.progress(key, 1.0);
                    completionHandler.complete(key, info, response);
                } else if (info.needRetry()) {
                    final String upHostRetry = config.zone.upHost(token.token, config.useHttps, upHost);
                    Log.d((String)"Qiniu.FormUploader", (String)("retry upload first time use up host " + upHostRetry));
                    CompletionHandler retried = new CompletionHandler(){

                        @Override
                        public void complete(ResponseInfo info, JSONObject response) {
                            if (info.isOK()) {
                                options.progressHandler.progress(key, 1.0);
                                completionHandler.complete(key, info, response);
                            } else if (info.needRetry()) {
                                final String upHostRetry2 = config.zone.upHost(token.token, config.useHttps, upHostRetry);
                                Log.d((String)"Qiniu.FormUploader", (String)("retry upload second time use up host " + upHostRetry2));
                                CompletionHandler retried2 = new CompletionHandler(){

                                    @Override
                                    public void complete(ResponseInfo info2, JSONObject response2) {
                                        if (info2.isOK()) {
                                            options.progressHandler.progress(key, 1.0);
                                        } else if (info2.needRetry()) {
                                            config.zone.frozenDomain(upHostRetry2);
                                        }
                                        completionHandler.complete(key, info2, response2);
                                    }
                                };
                                client.asyncMultipartPost(upHostRetry2, args, token, progress, retried2, options.cancellationSignal);
                            } else {
                                completionHandler.complete(key, info, response);
                            }
                        }
                    };
                    client.asyncMultipartPost(upHostRetry, args, token, progress, retried, options.cancellationSignal);
                } else {
                    completionHandler.complete(key, info, response);
                }
            }
        };
        client.asyncMultipartPost(upHost, args, token, progress, completion, options.cancellationSignal);
    }

    public static ResponseInfo syncUpload(Client client, Configuration config, byte[] data, String key, UpToken token, UploadOptions options) {
        try {
            return FormUploader.syncUpload0(client, config, data, null, key, token, options);
        }
        catch (Exception e) {
            return ResponseInfo.create(null, 0, "", "", "", "", "", "", 0, 0L, 0L, e.getMessage(), token, data != null ? (long)data.length : 0L);
        }
    }

    public static ResponseInfo syncUpload(Client client, Configuration config, File file, String key, UpToken token, UploadOptions options) {
        try {
            return FormUploader.syncUpload0(client, config, null, file, key, token, options);
        }
        catch (Exception e) {
            return ResponseInfo.create(null, 0, "", "", "", "", "", "", 0, 0L, 0L, e.getMessage(), token, file != null ? file.length() : 0L);
        }
    }

    private static ResponseInfo syncUpload0(Client client, Configuration config, byte[] data, File file, String key, UpToken token, UploadOptions optionsIn) {
        StringMap params = new StringMap();
        PostArgs args = new PostArgs();
        if (key != null) {
            params.put("key", key);
            args.fileName = key;
        } else {
            args.fileName = "?";
        }
        if (file != null) {
            args.fileName = file.getName();
        }
        params.put("token", token.token);
        UploadOptions options = optionsIn != null ? optionsIn : UploadOptions.defaultOptions();
        params.putFileds(options.params);
        long crc = 0L;
        if (file != null) {
            try {
                crc = Crc32.file(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            crc = Crc32.bytes(data);
        }
        params.put("crc32", "" + crc);
        args.data = data;
        args.file = file;
        args.mimeType = options.mimeType;
        args.params = params;
        boolean success = config.zone.preQuery(token.token);
        if (!success) {
            return ResponseInfo.invalidToken("failed to get up host");
        }
        String upHost = config.zone.upHost(token.token, config.useHttps, null);
        Log.d((String)"Qiniu.FormUploader", (String)("sync upload use up host " + upHost));
        ResponseInfo info = client.syncMultipartPost(upHost, args, token);
        if (info.isOK()) {
            return info;
        }
        if (info.needRetry()) {
            if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                options.netReadyHandler.waitReady();
                if (!AndroidNetwork.isNetWorkReady()) {
                    return info;
                }
            }
            String upHostRetry = config.zone.upHost(token.token, config.useHttps, upHost);
            Log.d((String)"Qiniu.FormUploader", (String)("sync upload retry first time use up host " + upHostRetry));
            info = client.syncMultipartPost(upHostRetry, args, token);
            if (info.needRetry()) {
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        return info;
                    }
                }
                String upHostRetry2 = config.zone.upHost(token.token, config.useHttps, upHostRetry);
                Log.d((String)"Qiniu.FormUploader", (String)("sync upload retry second time use up host " + upHostRetry2));
                info = client.syncMultipartPost(upHostRetry2, args, token);
                if (info.needRetry()) {
                    config.zone.frozenDomain(upHostRetry2);
                }
            }
        }
        return info;
    }
}

