/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.ServiceAddress;
import com.qiniu.android.common.Zone;
import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.utils.UrlSafeBase64;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private static Map<ZoneIndex, ZoneInfo> zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
    private static Client client = new Client();
    private final String ucServer;
    private final DnsManager dns;
    private final boolean https;

    public AutoZone(boolean https, DnsManager dns) {
        this("https://uc.qbox.me", https, dns);
    }

    AutoZone(String ucServer, boolean https, DnsManager dns) {
        this.ucServer = ucServer;
        this.https = https;
        this.dns = dns;
    }

    private void getZoneJsonAsync(ZoneIndex index, CompletionHandler handler) {
        String address = this.ucServer + "/v1/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        client.asyncGet(address, null, index.accessKey, handler);
    }

    private void putHosts(ZoneInfo info) {
        if (this.dns != null) {
            try {
                String httpDomain = new URI(info.upHost).getHost();
                String httpsDomain = new URI(info.upHttps).getHost();
                String httpBackDomain = new URI(info.upBackup).getHost();
                this.dns.putHosts(httpDomain, info.upIp);
                this.dns.putHosts(httpsDomain, info.upIp);
                this.dns.putHosts(httpBackDomain, info.upIp);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    ZoneInfo zoneInfo(String ak, String bucket) {
        ZoneIndex index = new ZoneIndex(ak, bucket);
        ZoneInfo info = zones.get(index);
        return info;
    }

    ZoneInfo queryByToken(String token) {
        try {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
            JSONObject obj = new JSONObject(policy);
            String scope = obj.getString("scope");
            String bkt = scope.split(":")[0];
            return this.zoneInfo(ak, bkt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ServiceAddress upHost(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return null;
        }
        if (this.https) {
            return new ServiceAddress(info.upHttps);
        }
        return new ServiceAddress(info.upHost, new String[]{info.upIp});
    }

    @Override
    public ServiceAddress upHostBackup(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return null;
        }
        if (this.https) {
            return null;
        }
        return new ServiceAddress(info.upBackup, new String[]{info.upIp});
    }

    void preQueryIndex(final ZoneIndex index, final Zone.QueryHandler complete) {
        if (index == null) {
            complete.onFailure(-5);
            return;
        }
        ZoneInfo info = zones.get(index);
        if (info != null) {
            complete.onSuccess();
            return;
        }
        this.getZoneJsonAsync(index, new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isOK() && response != null) {
                    try {
                        ZoneInfo info2 = ZoneInfo.buildFromJson(response);
                        zones.put(index, info2);
                        AutoZone.this.putHosts(info2);
                        complete.onSuccess();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        complete.onFailure(-1);
                    }
                }
            }
        });
    }

    @Override
    public void preQuery(String token, Zone.QueryHandler complete) {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        this.preQueryIndex(index, complete);
    }

    static class ZoneIndex {
        private final String accessKey;
        private final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public static ZoneIndex getFromToken(String token) {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = null;
            try {
                policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
                JSONObject obj = new JSONObject(policy);
                String scope = obj.getString("scope");
                String bkt = scope.split(":")[0];
                return new ZoneIndex(ak, bkt);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }

    static class ZoneInfo {
        final String upHost;
        final String upIp;
        final String upBackup;
        final String upHttps;

        private ZoneInfo(String upHost, String upIp, String upBackup, String upHttps) {
            this.upHost = upHost;
            this.upIp = upIp;
            this.upBackup = upBackup;
            this.upHttps = upHttps;
        }

        static ZoneInfo buildFromJson(JSONObject obj) throws JSONException {
            JSONObject http = obj.getJSONObject("http");
            JSONArray up = http.getJSONArray("up");
            String upHost = up.getString(1);
            String upBackup = up.getString(0);
            String upIp = up.getString(2).split(" ")[2].split("//")[1];
            JSONObject https = obj.getJSONObject("https");
            String upHttps = https.getJSONArray("up").getString(0);
            return new ZoneInfo(upHost, upIp, upBackup, upHttps);
        }
    }
}

