/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.PostArgs;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.StringMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.json.JSONObject;

final class FormUploader {
    FormUploader() {
    }

    static void upload(Client httpManager, Configuration config, byte[] data, String key, UpToken token, UpCompletionHandler completionHandler, UploadOptions options) {
        FormUploader.post(data, null, key, token, completionHandler, options, httpManager, config);
    }

    static void upload(Client client, Configuration config, File file, String key, UpToken token, UpCompletionHandler completionHandler, UploadOptions options) {
        FormUploader.post(null, file, key, token, completionHandler, options, client, config);
    }

    private static void post(byte[] data, File file, String k, final UpToken token, final UpCompletionHandler completionHandler, UploadOptions optionsIn, final Client client, final Configuration config) {
        final String key = k;
        StringMap params = new StringMap();
        final PostArgs args = new PostArgs();
        if (k != null) {
            params.put("key", key);
            args.fileName = key;
        } else {
            args.fileName = "?";
        }
        if (file != null) {
            args.fileName = file.getName();
        }
        params.put("token", token.token);
        final UploadOptions options = optionsIn != null ? optionsIn : UploadOptions.defaultOptions();
        params.putFileds(options.params);
        if (options.checkCrc) {
            long crc = 0L;
            if (file != null) {
                try {
                    crc = Crc32.file(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                crc = Crc32.bytes(data);
            }
            params.put("crc32", "" + crc);
        }
        final ProgressHandler progress = new ProgressHandler(){

            @Override
            public void onProgress(int bytesWritten, int totalSize) {
                double percent = (double)bytesWritten / (double)totalSize;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                options.progressHandler.progress(key, percent);
            }
        };
        args.data = data;
        args.file = file;
        args.mimeType = options.mimeType;
        args.params = params;
        args.userAgentPart = token.accessKey;
        CompletionHandler completion = new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        completionHandler.complete(key, info, response);
                        return;
                    }
                }
                if (info.isOK()) {
                    options.progressHandler.progress(key, 1.0);
                    completionHandler.complete(key, info, response);
                } else if (options.cancellationSignal.isCancelled()) {
                    ResponseInfo i = ResponseInfo.cancelled();
                    completionHandler.complete(key, i, null);
                } else if (info.needRetry() || info.isNotQiniu() && !token.hasReturnUrl()) {
                    CompletionHandler retried = new CompletionHandler(){

                        @Override
                        public void complete(ResponseInfo info, JSONObject response) {
                            if (info.isOK()) {
                                options.progressHandler.progress(key, 1.0);
                            }
                            completionHandler.complete(key, info, response);
                        }
                    };
                    URI u = config.zone.upHost((String)token.token).address;
                    if (config.zone.upHostBackup(token.token) != null && (info.needSwitchServer() || info.isNotQiniu())) {
                        u = config.zone.upHostBackup((String)token.token).address;
                    }
                    client.asyncMultipartPost(u.toString(), args, progress, retried, options.cancellationSignal);
                } else {
                    completionHandler.complete(key, info, response);
                }
            }
        };
        client.asyncMultipartPost(config.zone.upHost((String)token.token).address.toString(), args, progress, completion, options.cancellationSignal);
    }
}

