/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.utils.UrlSafeBase64;
import org.json.JSONException;
import org.json.JSONObject;

public final class UpToken {
    public final String token;
    public final String accessKey;
    private String returnUrl = null;

    private UpToken(JSONObject obj, String token, String accessKey) {
        this.returnUrl = obj.optString("returnUrl");
        this.token = token;
        this.accessKey = accessKey;
    }

    public static UpToken parse(String token) {
        JSONObject obj;
        String[] t;
        try {
            t = token.split(":");
        }
        catch (Exception e) {
            return null;
        }
        if (t.length != 3) {
            return null;
        }
        byte[] dtoken = UrlSafeBase64.decode(t[2]);
        try {
            obj = new JSONObject(new String(dtoken));
        }
        catch (JSONException e) {
            return null;
        }
        String scope = obj.optString("scope");
        if (scope.equals("")) {
            return null;
        }
        int deadline = obj.optInt("deadline");
        if (deadline == 0) {
            return null;
        }
        return new UpToken(obj, token, t[0]);
    }

    public String toString() {
        return this.token;
    }

    public boolean hasReturnUrl() {
        return !this.returnUrl.equals("");
    }
}

