/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.Zone;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUploader;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.ResumeUploader;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import java.io.File;
import org.json.JSONObject;

public final class UploadManager {
    private final Configuration config;
    private final Client client;

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration config) {
        this.config = config;
        this.client = new Client(config.proxy, config.connectTimeout, config.responseTimeout, config.urlConverter, config.dns);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    private static boolean areInvalidArg(final String key, byte[] data, File f, String token, final UpCompletionHandler completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("no UpCompletionHandler");
        }
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        ResponseInfo info = null;
        if (message != null) {
            info = ResponseInfo.invalidArgument(message);
        }
        if (f != null && f.length() == 0L || data != null && data.length == 0) {
            info = ResponseInfo.zeroSize();
        }
        if (info != null) {
            final ResponseInfo info2 = info;
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    completionHandler.complete(key, info2, null);
                }
            });
            return true;
        }
        return false;
    }

    public void put(final byte[] data, final String key, String token, final UpCompletionHandler complete, final UploadOptions options) {
        if (UploadManager.areInvalidArg(key, data, null, token, complete)) {
            return;
        }
        final UpCompletionHandler completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(final String key, final ResponseInfo info, final JSONObject response) {
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        complete.complete(key, info, response);
                    }
                });
            }
        };
        final UpToken decodedToken = UpToken.parse(token);
        if (decodedToken == null) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            completionHandler.complete(key, info, null);
            return;
        }
        Zone z = this.config.zone;
        z.preQuery(token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        FormUploader.upload(UploadManager.this.client, UploadManager.this.config, data, key, decodedToken, completionHandler, options);
                    }
                });
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.invalidToken("invalid token");
                completionHandler.complete(key, info, null);
            }
        });
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(final File file, final String key, String token, final UpCompletionHandler complete, final UploadOptions options) {
        if (UploadManager.areInvalidArg(key, null, file, token, complete)) {
            return;
        }
        final UpCompletionHandler completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(final String key, final ResponseInfo info, final JSONObject response) {
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        complete.complete(key, info, response);
                    }
                });
            }
        };
        final UpToken decodedToken = UpToken.parse(token);
        if (decodedToken == null) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            completionHandler.complete(key, info, null);
            return;
        }
        Zone z = this.config.zone;
        z.preQuery(token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                long size = file.length();
                if (size <= (long)((UploadManager)UploadManager.this).config.putThreshold) {
                    FormUploader.upload(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, completionHandler, options);
                    return;
                }
                String recorderKey = ((UploadManager)UploadManager.this).config.keyGen.gen(key, file);
                ResumeUploader uploader = new ResumeUploader(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, completionHandler, options, recorderKey);
                AsyncRun.runInMain(uploader);
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.invalidToken("invalid token");
                completionHandler.complete(key, info, null);
            }
        });
    }
}

