/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.AutoZone;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.ServiceAddress;
import com.qiniu.android.dns.DnsManager;

public abstract class Zone {
    public static final Zone zone0 = Zone.createZone("upload.qiniu.com", "up.qiniu.com", "183.136.139.10", "115.231.182.136");
    public static final Zone zone1 = Zone.createZone("upload-z1.qiniu.com", "up-z1.qiniu.com", "106.38.227.27", "106.38.227.28");
    public static final Zone zone2 = Zone.createZone("upload-z2.qiniu.com", "up-z2.qiniu.com", "183.60.214.197", "14.152.37.7");
    public static final Zone zoneNa0 = Zone.createZone("upload-na0.qiniu.com", "up-na0.qiniu.com", "23.236.102.3", "23.236.102.2");
    public static final AutoZone httpAutoZone = new AutoZone(false, null);
    public static final AutoZone httpsAutoZone = new AutoZone(true, null);

    private static Zone createZone(String upHost, String upHostBackup, String upIp, String upIp2) {
        String[] upIps = new String[]{upIp, upIp2};
        ServiceAddress up = new ServiceAddress("http://" + upHost, upIps);
        ServiceAddress upBackup = new ServiceAddress("http://" + upHostBackup, upIps);
        return new FixedZone(up, upBackup);
    }

    public static void addDnsIp(DnsManager dns) {
        zone0.upHost("").addIpToDns(dns);
        zone0.upHostBackup("").addIpToDns(dns);
        zone1.upHost("").addIpToDns(dns);
        zone1.upHostBackup("").addIpToDns(dns);
        zone2.upHost("").addIpToDns(dns);
        zone2.upHostBackup("").addIpToDns(dns);
    }

    public abstract ServiceAddress upHost(String var1);

    public abstract ServiceAddress upHostBackup(String var1);

    public abstract void preQuery(String var1, QueryHandler var2);

    public static interface QueryHandler {
        public void onSuccess();

        public void onFailure(int var1);
    }
}

