/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.IDN;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.chromium.net.CronetEngine;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.impl.UserAgent;
import org.chromium.net.impl.VersionSafeCallbacks;

public abstract class CronetEngineBuilderImpl
extends ICronetEngineBuilder {
    private static final Pattern INVALID_PKP_HOST_NAME = Pattern.compile("^[0-9\\.]*$");
    private final Context mApplicationContext;
    private final List<QuicHint> mQuicHints = new LinkedList<QuicHint>();
    private final List<Pkp> mPkps = new LinkedList<Pkp>();
    private boolean mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
    private String mUserAgent;
    private String mStoragePath;
    private VersionSafeCallbacks.LibraryLoader mLibraryLoader;
    private boolean mQuicEnabled;
    private boolean mHttp2Enabled;
    private boolean mSdchEnabled;
    private boolean mBrotiEnabled;
    private boolean mDisableCache;
    private int mHttpCacheMode;
    private long mHttpCacheMaxSize;
    private String mExperimentalOptions;
    protected long mMockCertVerifier;
    private boolean mNetworkQualityEstimatorEnabled;
    private String mCertVerifierData;

    public CronetEngineBuilderImpl(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.enableQuic(false);
        this.enableHttp2(true);
        this.enableSdch(false);
        this.enableBrotli(false);
        this.enableHttpCache(0, 0L);
        this.enableNetworkQualityEstimator(false);
        this.enablePublicKeyPinningBypassForLocalTrustAnchors(true);
    }

    public String getDefaultUserAgent() {
        return UserAgent.from(this.mApplicationContext);
    }

    public CronetEngineBuilderImpl setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    String getUserAgent() {
        return this.mUserAgent;
    }

    public CronetEngineBuilderImpl setStoragePath(String value) {
        if (!new File(value).isDirectory()) {
            throw new IllegalArgumentException("Storage path must be set to existing directory");
        }
        this.mStoragePath = value;
        return this;
    }

    String storagePath() {
        return this.mStoragePath;
    }

    public CronetEngineBuilderImpl setLibraryLoader(CronetEngine.Builder.LibraryLoader loader) {
        this.mLibraryLoader = new VersionSafeCallbacks.LibraryLoader(loader);
        return this;
    }

    VersionSafeCallbacks.LibraryLoader libraryLoader() {
        return this.mLibraryLoader;
    }

    public CronetEngineBuilderImpl enableQuic(boolean value) {
        this.mQuicEnabled = value;
        return this;
    }

    boolean quicEnabled() {
        return this.mQuicEnabled;
    }

    String getDefaultQuicUserAgentId() {
        return this.mQuicEnabled ? UserAgent.getQuicUserAgentIdFrom(this.mApplicationContext) : "";
    }

    public CronetEngineBuilderImpl enableHttp2(boolean value) {
        this.mHttp2Enabled = value;
        return this;
    }

    boolean http2Enabled() {
        return this.mHttp2Enabled;
    }

    public CronetEngineBuilderImpl enableSdch(boolean value) {
        this.mSdchEnabled = value;
        return this;
    }

    boolean sdchEnabled() {
        return this.mSdchEnabled;
    }

    public CronetEngineBuilderImpl enableBrotli(boolean value) {
        this.mBrotiEnabled = value;
        return this;
    }

    boolean brotliEnabled() {
        return this.mBrotiEnabled;
    }

    public CronetEngineBuilderImpl enableHttpCache(int cacheMode, long maxSize) {
        if (cacheMode == 3 || cacheMode == 2) {
            if (this.storagePath() == null) {
                throw new IllegalArgumentException("Storage path must be set");
            }
        } else if (this.storagePath() != null) {
            throw new IllegalArgumentException("Storage path must not be set");
        }
        this.mDisableCache = cacheMode == 0 || cacheMode == 2;
        this.mHttpCacheMaxSize = maxSize;
        switch (cacheMode) {
            case 0: {
                this.mHttpCacheMode = 0;
                break;
            }
            case 2: 
            case 3: {
                this.mHttpCacheMode = 1;
                break;
            }
            case 1: {
                this.mHttpCacheMode = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cache mode");
            }
        }
        return this;
    }

    boolean cacheDisabled() {
        return this.mDisableCache;
    }

    long httpCacheMaxSize() {
        return this.mHttpCacheMaxSize;
    }

    int httpCacheMode() {
        return this.mHttpCacheMode;
    }

    public CronetEngineBuilderImpl addQuicHint(String host, int port, int alternatePort) {
        if (host.contains("/")) {
            throw new IllegalArgumentException("Illegal QUIC Hint Host: " + host);
        }
        this.mQuicHints.add(new QuicHint(host, port, alternatePort));
        return this;
    }

    List<QuicHint> quicHints() {
        return this.mQuicHints;
    }

    public CronetEngineBuilderImpl addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
        if (hostName == null) {
            throw new NullPointerException("The hostname cannot be null");
        }
        if (pinsSha256 == null) {
            throw new NullPointerException("The set of SHA256 pins cannot be null");
        }
        if (expirationDate == null) {
            throw new NullPointerException("The pin expiration date cannot be null");
        }
        String idnHostName = CronetEngineBuilderImpl.validateHostNameForPinningAndConvert(hostName);
        HashSet<byte[]> hashes = new HashSet<byte[]>(pinsSha256.size());
        for (byte[] pinSha256 : pinsSha256) {
            if (pinSha256 == null || pinSha256.length != 32) {
                throw new IllegalArgumentException("Public key pin is invalid");
            }
            hashes.add(pinSha256);
        }
        this.mPkps.add(new Pkp(idnHostName, (byte[][])hashes.toArray((T[])new byte[hashes.size()][]), includeSubdomains, expirationDate));
        return this;
    }

    List<Pkp> publicKeyPins() {
        return this.mPkps;
    }

    public CronetEngineBuilderImpl enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
        this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled = value;
        return this;
    }

    boolean publicKeyPinningBypassForLocalTrustAnchorsEnabled() {
        return this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
    }

    private static String validateHostNameForPinningAndConvert(String hostName) throws IllegalArgumentException {
        if (INVALID_PKP_HOST_NAME.matcher(hostName).matches()) {
            throw new IllegalArgumentException("Hostname " + hostName + " is illegal." + " A hostname should not consist of digits and/or dots only.");
        }
        if (hostName.length() > 255) {
            throw new IllegalArgumentException("Hostname " + hostName + " is too long." + " The name of the host does not comply with RFC 1122 and RFC 1123.");
        }
        try {
            return IDN.toASCII(hostName, 2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Hostname " + hostName + " is illegal." + " The name of the host does not comply with RFC 1122 and RFC 1123.");
        }
    }

    public CronetEngineBuilderImpl setExperimentalOptions(String options) {
        this.mExperimentalOptions = options;
        return this;
    }

    public String experimentalOptions() {
        return this.mExperimentalOptions;
    }

    @VisibleForTesting
    public CronetEngineBuilderImpl setMockCertVerifierForTesting(long mockCertVerifier) {
        this.mMockCertVerifier = mockCertVerifier;
        return this;
    }

    long mockCertVerifier() {
        return this.mMockCertVerifier;
    }

    boolean networkQualityEstimatorEnabled() {
        return this.mNetworkQualityEstimatorEnabled;
    }

    public CronetEngineBuilderImpl setCertVerifierData(String certVerifierData) {
        this.mCertVerifierData = certVerifierData;
        return this;
    }

    public CronetEngineBuilderImpl enableNetworkQualityEstimator(boolean value) {
        this.mNetworkQualityEstimatorEnabled = value;
        return this;
    }

    String certVerifierData() {
        return this.mCertVerifierData;
    }

    Context getContext() {
        return this.mApplicationContext;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpCacheSetting {
    }

    public static class Pkp {
        final String mHost;
        final byte[][] mHashes;
        final boolean mIncludeSubdomains;
        final Date mExpirationDate;

        Pkp(String host, byte[][] hashes, boolean includeSubdomains, Date expirationDate) {
            this.mHost = host;
            this.mHashes = hashes;
            this.mIncludeSubdomains = includeSubdomains;
            this.mExpirationDate = expirationDate;
        }
    }

    public static class QuicHint {
        final String mHost;
        final int mPort;
        final int mAlternatePort;

        QuicHint(String host, int port, int alternatePort) {
            this.mHost = host;
            this.mPort = port;
            this.mAlternatePort = alternatePort;
        }
    }
}

