/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.chromium.net.ExperimentalUrlRequest;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.chromium.net.impl.CronetEngineBase;
import org.chromium.net.impl.UrlRequestBase;

public class UrlRequestBuilderImpl
extends ExperimentalUrlRequest.Builder {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String TAG = UrlRequestBuilderImpl.class.getSimpleName();
    private final CronetEngineBase mCronetEngine;
    private final String mUrl;
    private final UrlRequest.Callback mCallback;
    private final Executor mExecutor;
    private String mMethod;
    private final ArrayList<Pair<String, String>> mRequestHeaders = new ArrayList();
    private boolean mDisableCache;
    private boolean mDisableConnectionMigration;
    private int mPriority = 3;
    private Collection<Object> mRequestAnnotations;
    private UploadDataProvider mUploadDataProvider;
    private Executor mUploadDataProviderExecutor;
    private boolean mAllowDirectExecutor = false;

    UrlRequestBuilderImpl(String url, UrlRequest.Callback callback, Executor executor, CronetEngineBase cronetEngine) {
        if (url == null) {
            throw new NullPointerException("URL is required.");
        }
        if (callback == null) {
            throw new NullPointerException("Callback is required.");
        }
        if (executor == null) {
            throw new NullPointerException("Executor is required.");
        }
        if (cronetEngine == null) {
            throw new NullPointerException("CronetEngine is required.");
        }
        this.mUrl = url;
        this.mCallback = callback;
        this.mExecutor = executor;
        this.mCronetEngine = cronetEngine;
    }

    public ExperimentalUrlRequest.Builder setHttpMethod(String method) {
        if (method == null) {
            throw new NullPointerException("Method is required.");
        }
        this.mMethod = method;
        return this;
    }

    public UrlRequestBuilderImpl addHeader(String header, String value) {
        if (header == null) {
            throw new NullPointerException("Invalid header name.");
        }
        if (value == null) {
            throw new NullPointerException("Invalid header value.");
        }
        if (ACCEPT_ENCODING.equalsIgnoreCase(header)) {
            Log.w((String)TAG, (String)"It's not necessary to set Accept-Encoding on requests - cronet will do this automatically for you, and setting it yourself has no effect. See https://crbug.com/581399 for details.", (Throwable)new Exception());
            return this;
        }
        this.mRequestHeaders.add((Pair<String, String>)Pair.create((Object)header, (Object)value));
        return this;
    }

    public UrlRequestBuilderImpl disableCache() {
        this.mDisableCache = true;
        return this;
    }

    public UrlRequestBuilderImpl disableConnectionMigration() {
        this.mDisableConnectionMigration = true;
        return this;
    }

    public UrlRequestBuilderImpl setPriority(int priority) {
        this.mPriority = priority;
        return this;
    }

    public UrlRequestBuilderImpl setUploadDataProvider(UploadDataProvider uploadDataProvider, Executor executor) {
        if (uploadDataProvider == null) {
            throw new NullPointerException("Invalid UploadDataProvider.");
        }
        if (executor == null) {
            throw new NullPointerException("Invalid UploadDataProvider Executor.");
        }
        if (this.mMethod == null) {
            this.mMethod = "POST";
        }
        this.mUploadDataProvider = uploadDataProvider;
        this.mUploadDataProviderExecutor = executor;
        return this;
    }

    public UrlRequestBuilderImpl allowDirectExecutor() {
        this.mAllowDirectExecutor = true;
        return this;
    }

    public UrlRequestBuilderImpl addRequestAnnotation(Object annotation) {
        if (annotation == null) {
            throw new NullPointerException("Invalid metrics annotation.");
        }
        if (this.mRequestAnnotations == null) {
            this.mRequestAnnotations = new ArrayList<Object>();
        }
        this.mRequestAnnotations.add(annotation);
        return this;
    }

    public UrlRequestBase build() {
        UrlRequestBase request = this.mCronetEngine.createRequest(this.mUrl, this.mCallback, this.mExecutor, this.mPriority, this.mRequestAnnotations, this.mDisableCache, this.mDisableConnectionMigration, this.mAllowDirectExecutor);
        if (this.mMethod != null) {
            request.setHttpMethod(this.mMethod);
        }
        for (Pair<String, String> header : this.mRequestHeaders) {
            request.addHeader((String)header.first, (String)header.second);
        }
        if (this.mUploadDataProvider != null) {
            request.setUploadDataProvider(this.mUploadDataProvider, this.mUploadDataProviderExecutor);
        }
        return request;
    }
}

