/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.BuildConfig;
import org.chromium.base.Log;
import org.chromium.base.ObserverList;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.base.multidex.ChromiumMultiDexInstaller;

public class BaseChromiumApplication
extends Application {
    private static final String TAG = "base";
    private static final String TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS = "android.support.v7.internal.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "android.support.v7.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private final boolean mShouldInitializeApplicationStatusTracking;
    private ObserverList<WindowFocusChangedListener> mWindowFocusListeners = new ObserverList();

    public BaseChromiumApplication() {
        this(true);
    }

    protected BaseChromiumApplication(boolean shouldInitializeApplicationStatusTracking) {
        this.mShouldInitializeApplicationStatusTracking = shouldInitializeApplicationStatusTracking;
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        assert (this.getBaseContext() != null);
        this.checkAppBeingReplaced();
        if (BuildConfig.isMultidexEnabled()) {
            ChromiumMultiDexInstaller.install((Context)this);
        }
    }

    public void onCreate() {
        super.onCreate();
        if (this.mShouldInitializeApplicationStatusTracking) {
            this.startTrackingApplicationStatus();
        }
    }

    public void registerWindowFocusChangedListener(WindowFocusChangedListener listener) {
        this.mWindowFocusListeners.addObserver(listener);
    }

    public void unregisterWindowFocusChangedListener(WindowFocusChangedListener listener) {
        this.mWindowFocusListeners.removeObserver(listener);
    }

    public void initCommandLine() {
    }

    @VisibleForTesting
    public static void initCommandLine(Context context) {
        ((BaseChromiumApplication)context.getApplicationContext()).initCommandLine();
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private void checkAppBeingReplaced() {
        if (this.getResources() == null) {
            Log.e(TAG, "getResources() null, closing app.", new Object[0]);
            System.exit(0);
        }
    }

    private void startTrackingApplicationStatus() {
        ApplicationStatus.initialize(this);
        this.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                Window.Callback callback = activity.getWindow().getCallback();
                activity.getWindow().setCallback((Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, callback)));
            }

            public void onActivityDestroyed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }
        });
    }

    private class WindowCallbackProxy
    implements InvocationHandler {
        private final Window.Callback mCallback;
        private final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("onWindowFocusChanged") && args.length == 1 && args[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)args[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.mCallback, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AbstractMethodError) {
                    throw e.getCause();
                }
                throw e;
            }
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            this.mCallback.onWindowFocusChanged(hasFocus);
            for (WindowFocusChangedListener listener : BaseChromiumApplication.this.mWindowFocusListeners) {
                listener.onWindowFocusChanged(this.mActivity, hasFocus);
            }
        }
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }
}

