/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.StrictMode;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;

public class BuildInfo {
    private static final String TAG = "BuildInfo";
    private static final int MAX_FINGERPRINT_LENGTH = 128;

    private BuildInfo() {
    }

    @CalledByNative
    public static String getDevice() {
        return Build.DEVICE;
    }

    @CalledByNative
    public static String getBrand() {
        return Build.BRAND;
    }

    @CalledByNative
    public static String getAndroidBuildId() {
        return Build.ID;
    }

    @CalledByNative
    public static String getAndroidBuildFingerprint() {
        return Build.FINGERPRINT.substring(0, Math.min(Build.FINGERPRINT.length(), 128));
    }

    @CalledByNative
    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    @CalledByNative
    public static String getDeviceModel() {
        return Build.MODEL;
    }

    @CalledByNative
    public static String getGMSVersionCode() {
        String msg = "gms versionCode not available.";
        try {
            PackageManager packageManager = ContextUtils.getApplicationContext().getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo("com.google.android.gms", 0);
            msg = Integer.toString(packageInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, "GMS package is not found.", (Object)e);
        }
        return msg;
    }

    @CalledByNative
    public static String getPackageVersionCode() {
        String msg = "versionCode not available.";
        try {
            PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(BuildInfo.getPackageName(), 0);
            msg = "";
            if (pi.versionCode > 0) {
                msg = Integer.toString(pi.versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, msg);
        }
        return msg;
    }

    @CalledByNative
    public static String getPackageVersionName() {
        String msg = "versionName not available";
        try {
            PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(BuildInfo.getPackageName(), 0);
            msg = "";
            if (pi.versionName != null) {
                msg = pi.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d(TAG, msg);
        }
        return msg;
    }

    @CalledByNative
    public static String getExtractedFileSuffix() {
        PackageManager pm = ContextUtils.getApplicationContext().getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(ContextUtils.getApplicationContext().getPackageName(), 0);
            long version = pi.versionCode > 10 ? (long)pi.versionCode : pi.lastUpdateTime;
            return "@" + Long.toHexString(version);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static String getPackageLabel() {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            PackageManager packageManager = ContextUtils.getApplicationContext().getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(BuildInfo.getPackageName(), 128);
            CharSequence label = packageManager.getApplicationLabel(appInfo);
            String string = label != null ? label.toString() : "";
            return string;
        }
        catch (PackageManager.NameNotFoundException e) {
            String string = "";
            return string;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    @CalledByNative
    public static String getPackageName() {
        if (ContextUtils.getApplicationContext() == null) {
            return "";
        }
        return ContextUtils.getApplicationContext().getPackageName();
    }

    @CalledByNative
    public static String getBuildType() {
        return Build.TYPE;
    }

    public static boolean isDebugAndroid() {
        return "eng".equals(Build.TYPE) || "userdebug".equals(Build.TYPE);
    }

    @CalledByNative
    public static int getSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isAtLeastO() {
        if ("REL".equals(Build.VERSION.CODENAME)) {
            return Build.VERSION.SDK_INT >= 26;
        }
        return "O".equals(Build.VERSION.CODENAME) || Build.VERSION.CODENAME.startsWith("OMR");
    }

    public static boolean targetsAtLeastO(Context appContext) {
        if (appContext.getApplicationInfo().targetSdkVersion >= 26) {
            return true;
        }
        return ("O".equals(Build.VERSION.CODENAME) || Build.VERSION.CODENAME.startsWith("OMR")) && appContext.getApplicationInfo().targetSdkVersion == 10000;
    }
}

